# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .canonical import Canonical
from .uri import Uri
from .care_plan_detail_status import CarePlanDetailStatus
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CarePlanDetail(UniversalBaseModel):
    """
    Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    kind: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A description of the kind of resource the in-line definition of a care plan activity is representing. The CarePlan.activity.detail is an in-line definition when a resource is not referenced using CarePlan.activity.reference. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan activity.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Detailed description of the type of planned activity; e.g. what lab test, what procedure, what kind of encounter.
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    Provides the rationale that drove the inclusion of this particular activity as part of the plan or the reason why the activity was prohibited.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Indicates another resource, such as the health condition(s), whose existence justifies this request and drove the inclusion of this particular activity as part of the plan.
    """

    goal: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Internal reference that identifies the goals that this activity is intended to contribute towards meeting.
    """

    status: typing.Optional[CarePlanDetailStatus] = pydantic.Field(default=None)
    """
    Identifies what progress is being made for the specific activity.
    """

    status_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="statusReason")
    ] = pydantic.Field(default=None)
    """
    Provides reason why the activity isn't yet started, is on hold, was cancelled, etc.
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    If true, indicates that the described activity is one that must NOT be engaged in when following the plan. If false, or missing, indicates that the described activity is one that should be engaged in when following the plan.
    """

    scheduled_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="scheduledTiming")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    scheduled_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="scheduledPeriod")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    scheduled_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="scheduledString")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.
    """

    performer: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies who's expected to be involved in the activity.
    """

    product_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="productCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Identifies the food, drug or other product to be consumed or supplied in the activity.
    """

    product_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="productReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the food, drug or other product to be consumed or supplied in the activity.
    """

    daily_amount: typing_extensions.Annotated[
        typing.Optional[Quantity], FieldMetadata(alias="dailyAmount")
    ] = pydantic.Field(default=None)
    """
    Identifies the quantity expected to be consumed in a given day.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    Identifies the quantity expected to be supplied, administered or consumed by the subject.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    This provides a textual description of constraints on the intended activity occurrence, including relation to other activities. It may also include objectives, pre-conditions and end-conditions. Finally, it may convey specifics about the activity such as body site, method, route, etc.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
