# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .canonical import Canonical
from .uri import Uri
from .code import Code
from .date_time import DateTime
from .care_plan_activity import CarePlanActivity
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CarePlan(BaseResource):
    """
    Describes the intention of how one or more practitioners intend to deliver care for a particular patient, group or community for a period of time, possibly limited to care for a specific condition or set of conditions.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CarePlan"], FieldMetadata(alias="resourceType")
    ] = "CarePlan"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this care plan by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    instantiates_canonical: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="instantiatesCanonical"),
    ] = pydantic.Field(default=None)
    """
    The URL pointing to a FHIR-defined protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.
    """

    instantiates_uri: typing_extensions.Annotated[
        typing.Optional[typing.List[Uri]], FieldMetadata(alias="instantiatesUri")
    ] = pydantic.Field(default=None)
    """
    The URL pointing to an externally maintained protocol, guideline, questionnaire or other definition that is adhered to in whole or in part by this CarePlan.
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    A care plan that is fulfilled in whole or in part by this care plan.
    """

    replaces: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Completed or terminated care plan whose function is taken by this new care plan.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    A larger care plan of which this particular care plan is a component or step.
    """

    status: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates whether the plan is currently being acted upon, represents future intentions or is now a historical record.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the level of authority/intentionality associated with the care plan and where the care plan fits into the workflow chain.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    Identifies what "kind" of plan this is to support differentiation between multiple co-existing plans; e.g. "Home health", "psychiatric", "asthma", "disease management", "wellness plan", etc.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-friendly name for the care plan.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A description of the scope and nature of the plan.
    """

    subject: Reference = pydantic.Field()
    """
    Identifies the patient or group whose intended care is described by the plan.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which this CarePlan was created or to which the creation of this record is tightly associated.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    Indicates when the plan did (or is intended to) come into effect and end.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    Represents when this particular CarePlan record was created in the system, which is often a system-generated date.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    When populated, the author is responsible for the care plan. The care plan is attributed to the author.
    """

    contributor: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies the individual(s) or organization who provided the contents of the care plan.
    """

    care_team: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="careTeam")
    ] = pydantic.Field(default=None)
    """
    Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.
    """

    addresses: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.
    """

    supporting_info: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="supportingInfo")
    ] = pydantic.Field(default=None)
    """
    Identifies portions of the patient's record that specifically influenced the formation of the plan. These might include comorbidities, recent procedures, limitations, recent assessments, etc.
    """

    goal: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Describes the intended objective(s) of carrying out the care plan.
    """

    activity: typing.Optional[typing.List[CarePlanActivity]] = pydantic.Field(
        default=None
    )
    """
    Identifies a planned action to occur as part of the plan. For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    General notes about the care plan not covered elsewhere.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
