# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .capability_statement_rest_mode import CapabilityStatementRestMode
from .markdown import Markdown
from .capability_statement_security import CapabilityStatementSecurity
from .capability_statement_resource import CapabilityStatementResource
from .capability_statement_interaction_1 import CapabilityStatementInteraction1
from .capability_statement_search_param import CapabilityStatementSearchParam
from .capability_statement_operation import CapabilityStatementOperation
from .canonical import Canonical
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CapabilityStatementRest(UniversalBaseModel):
    """
    A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    mode: typing.Optional[CapabilityStatementRestMode] = pydantic.Field(default=None)
    """
    Identifies whether this portion of the statement is describing the ability to initiate or receive restful operations.
    """

    documentation: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Information about the system's restful capabilities that apply across all applications, such as security.
    """

    security: typing.Optional[CapabilityStatementSecurity] = pydantic.Field(
        default=None
    )
    """
    Information about security implementation from an interface perspective - what a client needs to know.
    """

    resource: typing.Optional[typing.List[CapabilityStatementResource]] = (
        pydantic.Field(default=None)
    )
    """
    A specification of the restful capabilities of the solution for a specific resource type.
    """

    interaction: typing.Optional[typing.List[CapabilityStatementInteraction1]] = (
        pydantic.Field(default=None)
    )
    """
    A specification of restful operations supported by the system.
    """

    search_param: typing_extensions.Annotated[
        typing.Optional[typing.List[CapabilityStatementSearchParam]],
        FieldMetadata(alias="searchParam"),
    ] = pydantic.Field(default=None)
    """
    Search parameters that are supported for searching all resources for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.
    """

    operation: typing.Optional[typing.List[CapabilityStatementOperation]] = (
        pydantic.Field(default=None)
    )
    """
    Definition of an operation or a named query together with its parameters and their meaning and type.
    """

    compartment: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    An absolute URI which is a reference to the definition of a compartment that the system supports. The reference is to a CompartmentDefinition resource by its canonical URL .
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
