# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .code import Code
from .canonical import Canonical
from .markdown import Markdown
from .capability_statement_interaction import CapabilityStatementInteraction
from .capability_statement_resource_versioning import (
    CapabilityStatementResourceVersioning,
)
from .capability_statement_resource_conditional_read import (
    CapabilityStatementResourceConditionalRead,
)
from .capability_statement_resource_conditional_delete import (
    CapabilityStatementResourceConditionalDelete,
)
from .capability_statement_resource_reference_policy_item import (
    CapabilityStatementResourceReferencePolicyItem,
)
from .capability_statement_search_param import CapabilityStatementSearchParam
from .capability_statement_operation import CapabilityStatementOperation
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CapabilityStatementResource(UniversalBaseModel):
    """
    A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    type: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A type of resource exposed via the restful interface.
    """

    profile: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    A specification of the profile that describes the solution's overall support for the resource, including any constraints on cardinality, bindings, lengths or other limitations. See further discussion in [Using Profiles](profiling.html#profile-uses).
    """

    supported_profile: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]], FieldMetadata(alias="supportedProfile")
    ] = pydantic.Field(default=None)
    """
    A list of profiles that represent different use cases supported by the system. For a server, "supported by the system" means the system hosts/produces a set of resources that are conformant to a particular profile, and allows clients that use its services to search using this profile and to find appropriate data. For a client, it means the system will search by this profile and process data according to the guidance implicit in the profile. See further discussion in [Using Profiles](profiling.html#profile-uses).
    """

    documentation: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Additional information about the resource type used by the system.
    """

    interaction: typing.Optional[typing.List[CapabilityStatementInteraction]] = (
        pydantic.Field(default=None)
    )
    """
    Identifies a restful operation supported by the solution.
    """

    versioning: typing.Optional[CapabilityStatementResourceVersioning] = pydantic.Field(
        default=None
    )
    """
    This field is set to no-version to specify that the system does not support (server) or use (client) versioning for this resource type. If this has some other value, the server must at least correctly track and populate the versionId meta-property on resources. If the value is 'versioned-update', then the server supports all the versioning features, including using e-tags for version integrity in the API.
    """

    read_history: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="readHistory")
    ] = pydantic.Field(default=None)
    """
    A flag for whether the server is able to return past versions as part of the vRead operation.
    """

    update_create: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="updateCreate")
    ] = pydantic.Field(default=None)
    """
    A flag to indicate that the server allows or needs to allow the client to create new identities on the server (that is, the client PUTs to a location where there is no existing resource). Allowing this operation means that the server allows the client to create new identities on the server.
    """

    conditional_create: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="conditionalCreate")
    ] = pydantic.Field(default=None)
    """
    A flag that indicates that the server supports conditional create.
    """

    conditional_read: typing_extensions.Annotated[
        typing.Optional[CapabilityStatementResourceConditionalRead],
        FieldMetadata(alias="conditionalRead"),
    ] = pydantic.Field(default=None)
    """
    A code that indicates how the server supports conditional read.
    """

    conditional_update: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="conditionalUpdate")
    ] = pydantic.Field(default=None)
    """
    A flag that indicates that the server supports conditional update.
    """

    conditional_delete: typing_extensions.Annotated[
        typing.Optional[CapabilityStatementResourceConditionalDelete],
        FieldMetadata(alias="conditionalDelete"),
    ] = pydantic.Field(default=None)
    """
    A code that indicates how the server supports conditional delete.
    """

    reference_policy: typing_extensions.Annotated[
        typing.Optional[typing.List[CapabilityStatementResourceReferencePolicyItem]],
        FieldMetadata(alias="referencePolicy"),
    ] = pydantic.Field(default=None)
    """
    A set of flags that defines how references are supported.
    """

    search_include: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="searchInclude")
    ] = pydantic.Field(default=None)
    """
    A list of \_include values supported by the server.
    """

    search_rev_include: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="searchRevInclude")
    ] = pydantic.Field(default=None)
    """
    A list of \_revinclude (reverse include) values supported by the server.
    """

    search_param: typing_extensions.Annotated[
        typing.Optional[typing.List[CapabilityStatementSearchParam]],
        FieldMetadata(alias="searchParam"),
    ] = pydantic.Field(default=None)
    """
    Search parameters for implementations to support and/or make use of - either references to ones defined in the specification, or additional ones defined for/by the implementation.
    """

    operation: typing.Optional[typing.List[CapabilityStatementOperation]] = (
        pydantic.Field(default=None)
    )
    """
    Definition of an operation or a named query together with its parameters and their meaning and type. Consult the definition of the operation for details about how to invoke the operation, and the parameters.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
