# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .capability_statement_status import CapabilityStatementStatus
from .date_time import DateTime
from .markdown import Markdown
from .capability_statement_kind import CapabilityStatementKind
from .canonical import Canonical
from .capability_statement_software import CapabilityStatementSoftware
from .capability_statement_implementation import CapabilityStatementImplementation
from .capability_statement_fhir_version import CapabilityStatementFhirVersion
from .code import Code
from .capability_statement_rest import CapabilityStatementRest
from .capability_statement_messaging import CapabilityStatementMessaging
from .capability_statement_document import CapabilityStatementDocument
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class CapabilityStatement(BaseResource):
    """
    A Capability Statement documents a set of capabilities (behaviors) of a FHIR Server for a particular version of FHIR that may be used as a statement of actual server functionality or a statement of required or desired server implementation.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["CapabilityStatement"], FieldMetadata(alias="resourceType")
    ] = "CapabilityStatement"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this capability statement when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this capability statement is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the capability statement is stored on different servers.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the capability statement when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the capability statement author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the capability statement. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the capability statement.
    """

    status: typing.Optional[CapabilityStatementStatus] = pydantic.Field(default=None)
    """
    The status of this capability statement. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this capability statement is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the capability statement was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the capability statement changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the capability statement.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the capability statement from a consumer's perspective. Typically, this is used when the capability statement describes a desired rather than an actual solution, for example as a formal expression of requirements as part of an RFP.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate capability statement instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the capability statement is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this capability statement is needed and why it has been designed as it has.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the capability statement and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the capability statement.
    """

    kind: typing.Optional[CapabilityStatementKind] = pydantic.Field(default=None)
    """
    The way that this statement is intended to be used, to describe an actual running instance of software, a particular product (kind, not instance of software) or a class of implementation (e.g. a desired purchase).
    """

    instantiates: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    Reference to a canonical URL of another CapabilityStatement that this software implements. This capability statement is a published API description that corresponds to a business service. The server may actually implement a subset of the capability statement it claims to implement, so the capability statement must specify the full capability details.
    """

    imports: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    Reference to a canonical URL of another CapabilityStatement that this software adds to. The capability statement automatically includes everything in the other statement, and it is not duplicated, though the server may repeat the same resources, interactions and operations to add additional details to them.
    """

    software: typing.Optional[CapabilityStatementSoftware] = pydantic.Field(
        default=None
    )
    """
    Software that is covered by this capability statement. It is used when the capability statement describes the capabilities of a particular software version, independent of an installation.
    """

    implementation: typing.Optional[CapabilityStatementImplementation] = pydantic.Field(
        default=None
    )
    """
    Identifies a specific implementation instance that is described by the capability statement - i.e. a particular installation, rather than the capabilities of a software program.
    """

    fhir_version: typing_extensions.Annotated[
        typing.Optional[CapabilityStatementFhirVersion],
        FieldMetadata(alias="fhirVersion"),
    ] = pydantic.Field(default=None)
    """
    The version of the FHIR specification that this CapabilityStatement describes (which SHALL be the same as the FHIR version of the CapabilityStatement itself). There is no default value.
    """

    format: typing.Optional[typing.List[Code]] = pydantic.Field(default=None)
    """
    A list of the formats supported by this implementation using their content types.
    """

    patch_format: typing_extensions.Annotated[
        typing.Optional[typing.List[Code]], FieldMetadata(alias="patchFormat")
    ] = pydantic.Field(default=None)
    """
    A list of the patch formats supported by this implementation using their content types.
    """

    implementation_guide: typing_extensions.Annotated[
        typing.Optional[typing.List[Canonical]],
        FieldMetadata(alias="implementationGuide"),
    ] = pydantic.Field(default=None)
    """
    A list of implementation guides that the server does (or should) support in their entirety.
    """

    rest: typing.Optional[typing.List[CapabilityStatementRest]] = pydantic.Field(
        default=None
    )
    """
    A definition of the restful capabilities of the solution, if any.
    """

    messaging: typing.Optional[typing.List[CapabilityStatementMessaging]] = (
        pydantic.Field(default=None)
    )
    """
    A description of the messaging capabilities of the solution.
    """

    document: typing.Optional[typing.List[CapabilityStatementDocument]] = (
        pydantic.Field(default=None)
    )
    """
    A document definition.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
