# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .bundle_link import BundleLink
from .uri import Uri
from .bundle_search import BundleSearch
from .bundle_request import BundleRequest
from .bundle_response import BundleResponse
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BundleEntry(UniversalBaseModel):
    """
    A container for a collection of resources.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    link: typing.Optional[typing.List[BundleLink]] = pydantic.Field(default=None)
    """
    A series of links that provide context to this entry.
    """

    full_url: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="fullUrl")
    ] = pydantic.Field(default=None)
    """
    The Absolute URL for the resource. The fullUrl SHALL NOT disagree with the id in the resource - i.e. if the fullUrl is not a urn:uuid, the URL shall be version-independent URL consistent with the Resource.id. The fullUrl is a version independent reference to the resource. The fullUrl element SHALL have a value except that: _ fullUrl can be empty on a POST (although it does not need to when specifying a temporary id for reference in the bundle) _ Results from operations might involve resources that are not identified.
    """

    resource: typing.Optional[typing.Any] = pydantic.Field(default=None)
    """
    The Resource for the entry. The purpose/meaning of the resource is determined by the Bundle.type.
    """

    search: typing.Optional[BundleSearch] = pydantic.Field(default=None)
    """
    Information about the search process that lead to the creation of this entry.
    """

    request: typing.Optional[BundleRequest] = pydantic.Field(default=None)
    """
    Additional information about how this entry should be processed as part of a transaction or batch. For history, it shows how the entry was processed to create the version contained in the entry.
    """

    response: typing.Optional[BundleResponse] = pydantic.Field(default=None)
    """
    Indicates the results of processing the corresponding 'request' entry in the batch or transaction being responded to or what the results of an operation where when returning history.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
