# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .id import Id
import pydantic
from .uri import Uri
from .code import Code
from .bundle_type import BundleType
from .instant import Instant
from .unsigned_int import UnsignedInt
from .bundle_link import BundleLink
from .bundle_entry import BundleEntry
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Bundle(UniversalBaseModel):
    """
    A container for a collection of resources.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Bundle"], FieldMetadata(alias="resourceType")
    ] = "Bundle"
    id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    """

    meta: typing.Optional[Meta] = pydantic.Field(default=None)
    """
    The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    """

    implicit_rules: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="implicitRules")
    ] = pydantic.Field(default=None)
    """
    A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    """

    language: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The base language in which the resource is written.
    """

    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    A persistent identifier for the bundle that won't change as a bundle is copied from server to server.
    """

    type: typing.Optional[BundleType] = pydantic.Field(default=None)
    """
    Indicates the purpose of this bundle - how it is intended to be used.
    """

    timestamp: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The date/time that the bundle was assembled - i.e. when the resources were placed in the bundle.
    """

    total: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    If a set of search matches, this is the total number of entries of type 'match' across all pages in the search. It does not include search.mode = 'include' or 'outcome' entries and it does not provide a count of the number of entries in the Bundle.
    """

    link: typing.Optional[typing.List[BundleLink]] = pydantic.Field(default=None)
    """
    A series of links that provide context to this bundle.
    """

    entry: typing.Optional[typing.List[BundleEntry]] = pydantic.Field(default=None)
    """
    An entry in a bundle resource - will either contain a resource or information about a resource (transactions and history only).
    """

    signature: typing.Optional[Signature] = pydantic.Field(default=None)
    """
    Digital Signature - base64 encoded. XML-DSig or a JWT.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
