# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .id import Id
import pydantic
from .uri import Uri
from .code import Code
from .bot_runtime_version import BotRuntimeVersion
from .bot_audit_event_trigger import BotAuditEventTrigger
from .bot_audit_event_destination_item import BotAuditEventDestinationItem
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Bot(UniversalBaseModel):
    """
    Bot account for automated actions.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Bot"], FieldMetadata(alias="resourceType")
    ] = "Bot"
    id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    """

    meta: typing.Optional[Meta] = pydantic.Field(default=None)
    """
    The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    """

    implicit_rules: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="implicitRules")
    ] = pydantic.Field(default=None)
    """
    A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    """

    language: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The base language in which the resource is written.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    An identifier for this bot.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A name associated with the Bot.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A summary, characterization or explanation of the Bot.
    """

    runtime_version: typing_extensions.Annotated[
        typing.Optional[BotRuntimeVersion], FieldMetadata(alias="runtimeVersion")
    ] = pydantic.Field(default=None)
    """
    The identifier of the bot runtime environment (i.e., vmcontext, awslambda, etc).
    """

    photo: typing.Optional[Attachment] = pydantic.Field(default=None)
    """
    Image of the bot.
    """

    cron_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="cronTiming")
    ] = pydantic.Field(default=None)
    """
    A schedule for the bot to be executed.
    """

    cron_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="cronString")
    ] = pydantic.Field(default=None)
    """
    A schedule for the bot to be executed.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A code that classifies the service for searching, sorting and display purposes (e.g. "Surgical Procedure").
    """

    run_as_user: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="runAsUser")
    ] = pydantic.Field(default=None)
    """
    Optional flag to indicate that the bot should be run as the user.
    """

    audit_event_trigger: typing_extensions.Annotated[
        typing.Optional[BotAuditEventTrigger], FieldMetadata(alias="auditEventTrigger")
    ] = pydantic.Field(default=None)
    """
    Criteria for creating an AuditEvent as a result of the bot invocation. Possible values are 'always', 'never', 'on-error', or 'on-output'. Default value is 'always'.
    """

    audit_event_destination: typing_extensions.Annotated[
        typing.Optional[typing.List[BotAuditEventDestinationItem]],
        FieldMetadata(alias="auditEventDestination"),
    ] = pydantic.Field(default=None)
    """
    The destination system in which the AuditEvent is to be sent. Possible values are 'log' or 'resource'. Default value is 'resource'.
    """

    source_code: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="sourceCode")
    ] = pydantic.Field(default=None)
    """
    Bot logic in original source code form written by developers.
    """

    executable_code: typing_extensions.Annotated[
        typing.Optional[Attachment], FieldMetadata(alias="executableCode")
    ] = pydantic.Field(default=None)
    """
    Bot logic in executable form as a result of compiling and bundling source code.
    """

    code: typing.Optional[str] = pydantic.Field(default=None)
    """
    DEPRECATED Bot logic script. Use Bot.sourceCode or Bot.executableCode instead.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
