# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BodyStructure(BaseResource):
    """
    Record details about an anatomical structure. This resource may be used when a coded concept does not provide the necessary detail needed for the use case.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["BodyStructure"], FieldMetadata(alias="resourceType")
    ] = "BodyStructure"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier for this instance of the anatomical structure.
    """

    active: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether this body site is in active use.
    """

    morphology: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The kind of structure being represented by the body structure at `BodyStructure.location`. This can define both normal and abnormal morphologies.
    """

    location: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    The anatomical location or region of the specimen, lesion, or body structure.
    """

    location_qualifier: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="locationQualifier"),
    ] = pydantic.Field(default=None)
    """
    Qualifier to refine the anatomical location. These include qualifiers for laterality, relative location, directionality, number, and plane.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    A summary, characterization or explanation of the body structure.
    """

    image: typing.Optional[typing.List[Attachment]] = pydantic.Field(default=None)
    """
    Image or images used to identify a location.
    """

    patient: Reference = pydantic.Field()
    """
    The person to which the body site belongs.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
