# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .biologically_derived_product_product_category import (
    BiologicallyDerivedProductProductCategory,
)
from .biologically_derived_product_status import BiologicallyDerivedProductStatus
from .biologically_derived_product_collection import (
    BiologicallyDerivedProductCollection,
)
from .biologically_derived_product_processing import (
    BiologicallyDerivedProductProcessing,
)
from .biologically_derived_product_manipulation import (
    BiologicallyDerivedProductManipulation,
)
from .biologically_derived_product_storage import BiologicallyDerivedProductStorage
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class BiologicallyDerivedProduct(BaseResource):
    """
    A material substance originating from a biological entity intended to be transplanted or infused into another (possibly the same) biological entity.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["BiologicallyDerivedProduct"],
        FieldMetadata(alias="resourceType"),
    ] = "BiologicallyDerivedProduct"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    This records identifiers associated with this biologically derived product instance that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).
    """

    product_category: typing_extensions.Annotated[
        typing.Optional[BiologicallyDerivedProductProductCategory],
        FieldMetadata(alias="productCategory"),
    ] = pydantic.Field(default=None)
    """
    Broad category of this product.
    """

    product_code: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="productCode")
    ] = pydantic.Field(default=None)
    """
    A code that identifies the kind of this biologically derived product (SNOMED Ctcode).
    """

    status: typing.Optional[BiologicallyDerivedProductStatus] = pydantic.Field(
        default=None
    )
    """
    Whether the product is currently available.
    """

    request: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Procedure request to obtain this biologically derived product.
    """

    quantity: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of discrete units within this product.
    """

    parent: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Parent product (if any).
    """

    collection: typing.Optional[BiologicallyDerivedProductCollection] = pydantic.Field(
        default=None
    )
    """
    How this product was collected.
    """

    processing: typing.Optional[typing.List[BiologicallyDerivedProductProcessing]] = (
        pydantic.Field(default=None)
    )
    """
    Any processing of the product during collection that does not change the fundamental nature of the product. For example adding anti-coagulants during the collection of Peripheral Blood Stem Cells.
    """

    manipulation: typing.Optional[BiologicallyDerivedProductManipulation] = (
        pydantic.Field(default=None)
    )
    """
    Any manipulation of product post-collection that is intended to alter the product. For example a buffy-coat enrichment or CD8 reduction of Peripheral Blood Stem Cells to make it more suitable for infusion.
    """

    storage: typing.Optional[typing.List[BiologicallyDerivedProductStorage]] = (
        pydantic.Field(default=None)
    )
    """
    Product storage.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
