# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .id import Id
import pydantic
from .uri import Uri
from .code import Code
from .base_64_binary import Base64Binary
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Binary(UniversalBaseModel):
    """
    A resource that represents the data of a single raw artifact as digital content accessible in its native format. A Binary resource can contain any content, whether text, image, pdf, zip archive, etc.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Binary"], FieldMetadata(alias="resourceType")
    ] = "Binary"
    id: typing.Optional[Id] = pydantic.Field(default=None)
    """
    The logical id of the resource, as used in the URL for the resource. Once assigned, this value never changes.
    """

    meta: typing.Optional[Meta] = pydantic.Field(default=None)
    """
    The metadata about the resource. This is content that is maintained by the infrastructure. Changes to the content might not always be associated with version changes to the resource.
    """

    implicit_rules: typing_extensions.Annotated[
        typing.Optional[Uri], FieldMetadata(alias="implicitRules")
    ] = pydantic.Field(default=None)
    """
    A reference to a set of rules that were followed when the resource was constructed, and which must be understood when processing the content. Often, this is a reference to an implementation guide that defines the special rules along with other profiles etc.
    """

    language: typing.Optional[Code] = pydantic.Field(default=None)
    """
    The base language in which the resource is written.
    """

    content_type: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="contentType")
    ] = pydantic.Field(default=None)
    """
    MimeType of the binary content represented as a standard MimeType (BCP 13).
    """

    security_context: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="securityContext")
    ] = pydantic.Field(default=None)
    """
    This element identifies another resource that can be used as a proxy of the security sensitivity to use when deciding and enforcing access control rules for the Binary resource. Given that the Binary resource contains very few elements that can be used to determine the sensitivity of the data and relationships to individuals, the referenced resource stands in as a proxy equivalent for this purpose. This referenced resource may be related to the Binary (e.g. Media, DocumentReference), or may be some non-related Resource purely as a security proxy. E.g. to identify that the binary resource relates to a patient, and access should only be granted to applications that have access to the patient.
    """

    data: typing.Optional[Base64Binary] = pydantic.Field(default=None)
    """
    The actual content, base64 encoded.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
