# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
import datetime as dt
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Basic(BaseResource):
    """
    Basic is used for handling concepts not yet defined in FHIR, narrative-only resources that don't map to an existing resource, and custom resources not appropriate for inclusion in the FHIR specification.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Basic"], FieldMetadata(alias="resourceType")
    ] = "Basic"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Identifier assigned to the resource for business purposes, outside the context of FHIR.
    """

    code: CodeableConcept = pydantic.Field()
    """
    Identifies the 'type' of resource - equivalent to the resource name for other resources.
    """

    subject: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the patient, practitioner, device or any other resource that is the "focus" of this resource.
    """

    created: typing.Optional[dt.date] = pydantic.Field(default=None)
    """
    Identifies when the resource was first created.
    """

    author: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates who was responsible for creating the resource instance.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
