# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from .uri import Uri
from .audit_event_network import AuditEventNetwork
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AuditEventAgent(UniversalBaseModel):
    """
    A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    Unique id for the element within a resource (for internal references). This may be any string value that does not contain spaces.
    """

    extension: typing.Optional[typing.List[Extension]] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.
    """

    modifier_extension: typing_extensions.Annotated[
        typing.Optional[typing.List[Extension]],
        FieldMetadata(alias="modifierExtension"),
    ] = pydantic.Field(default=None)
    """
    May be used to represent additional information that is not part of the basic definition of the element and that modifies the understanding of the element in which it is contained and/or the understanding of the containing element's descendants. Usually modifier elements provide negation or qualification. To make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer can define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions. Modifier extensions SHALL NOT change the meaning of any elements on Resource or DomainResource (including cannot change the meaning of modifierExtension itself).
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Specification of the participation type the user plays when performing the event.
    """

    role: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    The security role that the user was acting under, that come from local codes defined by the access control security system (e.g. RBAC, ABAC) used in the local context.
    """

    who: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Reference to who this agent is that was involved in the event.
    """

    alt_id: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="altId")
    ] = pydantic.Field(default=None)
    """
    Alternative agent Identifier. For a human, this should be a user identifier text string from authentication system. This identifier would be one known to a common authentication system (e.g. single sign-on), if available.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Human-meaningful name for the agent.
    """

    requestor: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Indicator that the user is or is not the requestor, or initiator, for the event being audited.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Where the event occurred.
    """

    policy: typing.Optional[typing.List[Uri]] = pydantic.Field(default=None)
    """
    The policy or plan that authorized the activity being recorded. Typically, a single activity may have multiple applicable policies, such as patient consent, guarantor funding, etc. The policy would also indicate the security token used.
    """

    media: typing.Optional[Coding] = pydantic.Field(default=None)
    """
    Type of media involved. Used when the event is about exporting/importing onto media.
    """

    network: typing.Optional[AuditEventNetwork] = pydantic.Field(default=None)
    """
    Logical network location for application activity, if the activity has a network location.
    """

    purpose_of_use: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="purposeOfUse"),
    ] = pydantic.Field(default=None)
    """
    The reason (purpose of use), specific to this agent, that was used during the event being recorded.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
