# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .audit_event_action import AuditEventAction
from .instant import Instant
from .audit_event_outcome import AuditEventOutcome
from .audit_event_agent import AuditEventAgent
from .audit_event_source import AuditEventSource
from .audit_event_entity import AuditEventEntity
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AuditEvent(BaseResource):
    """
    A record of an event made for purposes of maintaining a security log. Typical uses include detection of intrusion attempts and monitoring for inappropriate usage.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["AuditEvent"], FieldMetadata(alias="resourceType")
    ] = "AuditEvent"
    type: Coding = pydantic.Field()
    """
    Identifier for a family of the event. For example, a menu item, program, rule, policy, function code, application name or URL. It identifies the performed function.
    """

    subtype: typing.Optional[typing.List[Coding]] = pydantic.Field(default=None)
    """
    Identifier for the category of event.
    """

    action: typing.Optional[AuditEventAction] = pydantic.Field(default=None)
    """
    Indicator for type of action performed during the event that generated the audit.
    """

    period: typing.Optional[Period] = pydantic.Field(default=None)
    """
    The period during which the activity occurred.
    """

    recorded: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    The time when the event was recorded.
    """

    outcome: typing.Optional[AuditEventOutcome] = pydantic.Field(default=None)
    """
    Indicates whether the event succeeded or failed.
    """

    outcome_desc: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="outcomeDesc")
    ] = pydantic.Field(default=None)
    """
    A free text description of the outcome of the event.
    """

    purpose_of_event: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="purposeOfEvent"),
    ] = pydantic.Field(default=None)
    """
    The purposeOfUse (reason) that was used during the event being recorded.
    """

    agent: typing.List[AuditEventAgent] = pydantic.Field()
    """
    An actor taking an active role in the event or activity that is logged.
    """

    source: AuditEventSource = pydantic.Field()
    """
    The system that is reporting the event.
    """

    entity: typing.Optional[typing.List[AuditEventEntity]] = pydantic.Field(
        default=None
    )
    """
    Specific instances of data or objects that have been accessed.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
