# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .instant import Instant
from .code import Code
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AppointmentResponse(BaseResource):
    """
    A reply to an appointment request for a patient and/or practitioner(s), such as a confirmation or rejection.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["AppointmentResponse"], FieldMetadata(alias="resourceType")
    ] = "AppointmentResponse"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    This records identifiers associated with this appointment response concern that are defined by business processes and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate.
    """

    appointment: Reference = pydantic.Field()
    """
    Appointment that this response is replying to.
    """

    start: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    Date/Time that the appointment is to take place, or requested new start time.
    """

    end: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    This may be either the same as the appointment request to confirm the details of the appointment, or alternately a new time to request a re-negotiation of the end time.
    """

    participant_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="participantType"),
    ] = pydantic.Field(default=None)
    """
    Role of participant in the appointment.
    """

    actor: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    A Person, Location, HealthcareService, or Device that is participating in the appointment.
    """

    participant_status: typing_extensions.Annotated[
        typing.Optional[Code], FieldMetadata(alias="participantStatus")
    ] = pydantic.Field(default=None)
    """
    Participation status of the participant. When the status is declined or tentative if the start/end times are different to the appointment, then these times should be interpreted as a requested time change. When the status is accepted, the times can either be the time of the appointment (as a confirmation of the time) or can be empty.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional comments about the appointment.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
