# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .appointment_status import AppointmentStatus
from .unsigned_int import UnsignedInt
from .instant import Instant
from .positive_int import PositiveInt
from .date_time import DateTime
from .appointment_participant import AppointmentParticipant
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Appointment(BaseResource):
    """
    A booking of a healthcare event among patient(s), practitioner(s), related person(s) and/or device(s) for a specific date/time. This may result in one or more Encounter(s).
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Appointment"], FieldMetadata(alias="resourceType")
    ] = "Appointment"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    This records identifiers associated with this appointment concern that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation).
    """

    status: typing.Optional[AppointmentStatus] = pydantic.Field(default=None)
    """
    The overall status of the Appointment. Each of the participants has their own participation status which indicates their involvement in the process, however this status indicates the shared status.
    """

    cancelation_reason: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="cancelationReason")
    ] = pydantic.Field(default=None)
    """
    The coded reason for the appointment being cancelled. This is often used in reporting/billing/futher processing to determine if further actions are required, or specific fees apply.
    """

    service_category: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceCategory"),
    ] = pydantic.Field(default=None)
    """
    A broad categorization of the service that is to be performed during this appointment.
    """

    service_type: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]],
        FieldMetadata(alias="serviceType"),
    ] = pydantic.Field(default=None)
    """
    The specific service that is to be performed during this appointment.
    """

    specialty: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The specialty of a practitioner that would be required to perform the service requested in this appointment.
    """

    appointment_type: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="appointmentType")
    ] = pydantic.Field(default=None)
    """
    The style of appointment or patient that has been booked in the slot (not service type).
    """

    reason_code: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="reasonCode")
    ] = pydantic.Field(default=None)
    """
    The coded reason that this appointment is being scheduled. This is more clinical than administrative.
    """

    reason_reference: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="reasonReference")
    ] = pydantic.Field(default=None)
    """
    Reason the appointment has been scheduled to take place, as specified using information from another resource. When the patient arrives and the encounter begins it may be used as the admission diagnosis. The indication will typically be a Condition (with other resources referenced in the evidence.detail), or a Procedure.
    """

    priority: typing.Optional[UnsignedInt] = pydantic.Field(default=None)
    """
    The priority of the appointment. Can be used to make informed decisions if needing to re-prioritize appointments. (The iCal Standard specifies 0 as undefined, 1 as highest, 9 as lowest priority).
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The brief description of the appointment as would be shown on a subject line in a meeting request, or appointment list. Detailed or expanded information should be put in the comment field.
    """

    supporting_information: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="supportingInformation"),
    ] = pydantic.Field(default=None)
    """
    Additional information to support the appointment provided when making the appointment.
    """

    start: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    Date/Time that the appointment is to take place.
    """

    end: typing.Optional[Instant] = pydantic.Field(default=None)
    """
    Date/Time that the appointment is to conclude.
    """

    minutes_duration: typing_extensions.Annotated[
        typing.Optional[PositiveInt], FieldMetadata(alias="minutesDuration")
    ] = pydantic.Field(default=None)
    """
    Number of minutes that the appointment is to take. This can be less than the duration between the start and end times. For example, where the actual time of appointment is only an estimate or if a 30 minute appointment is being requested, but any time would work. Also, if there is, for example, a planned 15 minute break in the middle of a long appointment, the duration may be 15 minutes less than the difference between the start and end.
    """

    slot: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    The slots from the participants' schedules that will be filled by the appointment.
    """

    created: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date that this appointment was initially created. This could be different to the meta.lastModified value on the initial entry, as this could have been before the resource was created on the FHIR server, and should remain unchanged over the lifespan of the appointment.
    """

    comment: typing.Optional[str] = pydantic.Field(default=None)
    """
    Additional comments about the appointment.
    """

    patient_instruction: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="patientInstruction")
    ] = pydantic.Field(default=None)
    """
    While Appointment.comment contains information for internal use, Appointment.patientInstructions is used to capture patient facing information about the Appointment (e.g. please bring your referral or fast from 8pm night before).
    """

    based_on: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]], FieldMetadata(alias="basedOn")
    ] = pydantic.Field(default=None)
    """
    The service request this appointment is allocated to assess (e.g. incoming referral or procedure request).
    """

    participant: typing.List[AppointmentParticipant] = pydantic.Field()
    """
    List of participants involved in the appointment.
    """

    requested_period: typing_extensions.Annotated[
        typing.Optional[typing.List[Period]], FieldMetadata(alias="requestedPeriod")
    ] = pydantic.Field(default=None)
    """
    A set of date ranges (potentially including times) that the appointment is preferred to be scheduled within. The duration (usually in minutes) could also be provided to indicate the length of the appointment to fill and populate the start/end times for the actual allocated time. However, in other situations the duration may be calculated by the scheduling system.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
