# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .allergy_intolerance_type import AllergyIntoleranceType
from .allergy_intolerance_category_item import AllergyIntoleranceCategoryItem
from .allergy_intolerance_criticality import AllergyIntoleranceCriticality
from .date_time import DateTime
from .allergy_intolerance_reaction import AllergyIntoleranceReaction
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AllergyIntolerance(BaseResource):
    """
    Risk of harmful or undesirable, physiological response which is unique to an individual and associated with exposure to a substance.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["AllergyIntolerance"], FieldMetadata(alias="resourceType")
    ] = "AllergyIntolerance"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this AllergyIntolerance by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    clinical_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="clinicalStatus")
    ] = pydantic.Field(default=None)
    """
    The clinical status of the allergy or intolerance.
    """

    verification_status: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="verificationStatus")
    ] = pydantic.Field(default=None)
    """
    Assertion about certainty associated with the propensity, or potential risk, of a reaction to the identified substance (including pharmaceutical product).
    """

    type: typing.Optional[AllergyIntoleranceType] = pydantic.Field(default=None)
    """
    Identification of the underlying physiological mechanism for the reaction risk.
    """

    category: typing.Optional[typing.List[AllergyIntoleranceCategoryItem]] = (
        pydantic.Field(default=None)
    )
    """
    Category of the identified substance.
    """

    criticality: typing.Optional[AllergyIntoleranceCriticality] = pydantic.Field(
        default=None
    )
    """
    Estimate of the potential clinical harm, or seriousness, of the reaction to the identified substance.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Code for an allergy or intolerance statement (either a positive or a negated/excluded statement). This may be a code for a substance or pharmaceutical product that is considered to be responsible for the adverse reaction risk (e.g., "Latex"), an allergy or intolerance condition (e.g., "Latex allergy"), or a negated/excluded code for a specific substance or class (e.g., "No latex allergy") or a general or categorical negated statement (e.g., "No known allergy", "No known drug allergies"). Note: the substance for a specific reaction may be different from the substance identified as the cause of the risk, but it must be consistent with it. For instance, it may be a more specific substance (e.g. a brand medication) or a composite product that includes the identified substance. It must be clinically safe to only process the 'code' and ignore the 'reaction.substance'. If a receiving system is unable to confirm that AllergyIntolerance.reaction.substance falls within the semantic scope of AllergyIntolerance.code, then the receiving system should ignore AllergyIntolerance.reaction.substance.
    """

    patient: Reference = pydantic.Field()
    """
    The patient who has the allergy or intolerance.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The encounter when the allergy or intolerance was asserted.
    """

    onset_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="onsetDateTime")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, or age when allergy or intolerance was identified.
    """

    onset_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="onsetAge")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, or age when allergy or intolerance was identified.
    """

    onset_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="onsetPeriod")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, or age when allergy or intolerance was identified.
    """

    onset_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="onsetRange")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, or age when allergy or intolerance was identified.
    """

    onset_string: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="onsetString")
    ] = pydantic.Field(default=None)
    """
    Estimated or actual date, date-time, or age when allergy or intolerance was identified.
    """

    recorded_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="recordedDate")
    ] = pydantic.Field(default=None)
    """
    The recordedDate represents when this particular AllergyIntolerance record was created in the system, which is often a system-generated date.
    """

    recorder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Individual who recorded the record and takes responsibility for its content.
    """

    asserter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The source of the information about the allergy that is recorded.
    """

    last_occurrence: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="lastOccurrence")
    ] = pydantic.Field(default=None)
    """
    Represents the date and/or time of the last known occurrence of a reaction event.
    """

    note: typing.Optional[typing.List[Annotation]] = pydantic.Field(default=None)
    """
    Additional narrative about the propensity for the Adverse Reaction, not captured in other fields.
    """

    reaction: typing.Optional[typing.List[AllergyIntoleranceReaction]] = pydantic.Field(
        default=None
    )
    """
    Details about each adverse reaction event linked to exposure to the identified substance.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
