# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import pydantic
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .url import Url
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AgentChannel(UniversalBaseModel):
    """
    Details where to send notifications when resources are received that meet the criteria.
    """

    endpoint: Reference = pydantic.Field()
    """
    The channel endpoint definition including protocol and network binding details.
    """

    target_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="targetReference")
    ] = pydantic.Field(default=None)
    """
    The target resource where channel messages will be delivered.
    """

    target_url: typing_extensions.Annotated[
        typing.Optional[Url], FieldMetadata(alias="targetUrl")
    ] = pydantic.Field(default=None)
    """
    The target resource where channel messages will be delivered.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
