# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .adverse_event_actuality import AdverseEventActuality
from .date_time import DateTime
from .adverse_event_suspect_entity import AdverseEventSuspectEntity
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AdverseEvent(BaseResource):
    """
    Actual or potential/avoided event causing unintended physical injury resulting from or contributed to by medical care, a research study or other healthcare setting factors that requires additional monitoring, treatment, or hospitalization, or that results in death.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["AdverseEvent"], FieldMetadata(alias="resourceType")
    ] = "AdverseEvent"
    identifier: typing.Optional[Identifier] = pydantic.Field(default=None)
    """
    Business identifiers assigned to this adverse event by the performer or other systems which remain constant as the resource is updated and propagates from server to server.
    """

    actuality: typing.Optional[AdverseEventActuality] = pydantic.Field(default=None)
    """
    Whether the event actually happened, or just had the potential to. Note that this is independent of whether anyone was affected or harmed or how severely.
    """

    category: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    The overall type of event, intended for search and filtering purposes.
    """

    event: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    This element defines the specific type of event that occurred or that was prevented from occurring.
    """

    subject: Reference = pydantic.Field()
    """
    This subject or group impacted by the event.
    """

    encounter: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The Encounter during which AdverseEvent was created or to which the creation of this record is tightly associated.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and perhaps time) when the adverse event occurred.
    """

    detected: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    Estimated or actual date the AdverseEvent began, in the opinion of the reporter.
    """

    recorded_date: typing_extensions.Annotated[
        typing.Optional[DateTime], FieldMetadata(alias="recordedDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the existence of the AdverseEvent was first recorded.
    """

    resulting_condition: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="resultingCondition"),
    ] = pydantic.Field(default=None)
    """
    Includes information about the reaction that occurred as a result of exposure to a substance (for example, a drug or a chemical).
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The information about where the adverse event occurred.
    """

    seriousness: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Assessment whether this event was of real importance.
    """

    severity: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Describes the severity of the adverse event, in relation to the subject. Contrast to AdverseEvent.seriousness - a severe rash might not be serious, but a mild heart problem is.
    """

    outcome: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Describes the type of outcome from the adverse event.
    """

    recorder: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Information on who recorded the adverse event. May be the patient or a practitioner.
    """

    contributor: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Parties that may or should contribute or have contributed information to the adverse event, which can consist of one or more activities. Such information includes information leading to the decision to perform the activity and how to perform the activity (e.g. consultant), information that the activity itself seeks to reveal (e.g. informant of clinical history), or information about what activity was performed (e.g. informant witness).
    """

    suspect_entity: typing_extensions.Annotated[
        typing.Optional[typing.List[AdverseEventSuspectEntity]],
        FieldMetadata(alias="suspectEntity"),
    ] = pydantic.Field(default=None)
    """
    Describes the entity that is suspected to have caused the adverse event.
    """

    subject_medical_history: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="subjectMedicalHistory"),
    ] = pydantic.Field(default=None)
    """
    AdverseEvent.subjectMedicalHistory.
    """

    reference_document: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="referenceDocument"),
    ] = pydantic.Field(default=None)
    """
    AdverseEvent.referenceDocument.
    """

    study: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    AdverseEvent.study.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
