# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
from .uri import Uri
import pydantic
from .activity_definition_status import ActivityDefinitionStatus
from .date_time import DateTime
from .markdown import Markdown
import datetime as dt
from .canonical import Canonical
from .code import Code
from .activity_definition_participant import ActivityDefinitionParticipant
from .activity_definition_dynamic_value import ActivityDefinitionDynamicValue
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class ActivityDefinition(BaseResource):
    """
    This resource allows for the definition of some activity to be performed, independent of a particular patient, practitioner, or other performance context.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["ActivityDefinition"], FieldMetadata(alias="resourceType")
    ] = "ActivityDefinition"
    url: typing.Optional[Uri] = pydantic.Field(default=None)
    """
    An absolute URI that is used to identify this activity definition when it is referenced in a specification, model, design or an instance; also called its canonical identifier. This SHOULD be globally unique and SHOULD be a literal address at which at which an authoritative instance of this activity definition is (or will be) published. This URL can be the target of a canonical reference. It SHALL remain the same when the activity definition is stored on different servers.
    """

    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    A formal identifier that is used to identify this activity definition when it is represented in other formats, or referenced in a specification, model, design or an instance.
    """

    version: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier that is used to identify this version of the activity definition when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the activity definition author and is not expected to be globally unique. For example, it might be a timestamp (e.g. yyyymmdd) if a managed version is not available. There is also no expectation that versions can be placed in a lexicographical sequence. To provide a version consistent with the Decision Support Service specification, use the format Major.Minor.Revision (e.g. 1.0.0). For more information on versioning knowledge assets, refer to the Decision Support Service specification. Note that a version is required for non-experimental active assets.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    A natural language name identifying the activity definition. This name should be usable as an identifier for the module by machine processing applications such as code generation.
    """

    title: typing.Optional[str] = pydantic.Field(default=None)
    """
    A short, descriptive, user-friendly title for the activity definition.
    """

    subtitle: typing.Optional[str] = pydantic.Field(default=None)
    """
    An explanatory or alternate title for the activity definition giving additional information about its content.
    """

    status: typing.Optional[ActivityDefinitionStatus] = pydantic.Field(default=None)
    """
    The status of this activity definition. Enables tracking the life-cycle of the content.
    """

    experimental: typing.Optional[bool] = pydantic.Field(default=None)
    """
    A Boolean value to indicate that this activity definition is authored for testing purposes (or education/evaluation/marketing) and is not intended to be used for genuine usage.
    """

    subject_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="subjectCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the activity being defined.
    """

    subject_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="subjectReference")
    ] = pydantic.Field(default=None)
    """
    A code or group definition that describes the intended subject of the activity being defined.
    """

    date: typing.Optional[DateTime] = pydantic.Field(default=None)
    """
    The date (and optionally time) when the activity definition was published. The date must change when the business version changes and it must change if the status code changes. In addition, it should change when the substantive content of the activity definition changes.
    """

    publisher: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the organization or individual that published the activity definition.
    """

    contact: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    Contact details to assist a user in finding and communicating with the publisher.
    """

    description: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A free text natural language description of the activity definition from a consumer's perspective.
    """

    use_context: typing_extensions.Annotated[
        typing.Optional[typing.List[UsageContext]], FieldMetadata(alias="useContext")
    ] = pydantic.Field(default=None)
    """
    The content was developed with a focus and intent of supporting the contexts that are listed. These contexts may be general categories (gender, age, ...) or may be references to specific programs (insurance plans, studies, ...) and may be used to assist with indexing and searching for appropriate activity definition instances.
    """

    jurisdiction: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(
        default=None
    )
    """
    A legal or geographic region in which the activity definition is intended to be used.
    """

    purpose: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    Explanation of why this activity definition is needed and why it has been designed as it has.
    """

    usage: typing.Optional[str] = pydantic.Field(default=None)
    """
    A detailed description of how the activity definition is used from a clinical perspective.
    """

    copyright: typing.Optional[Markdown] = pydantic.Field(default=None)
    """
    A copyright statement relating to the activity definition and/or its contents. Copyright statements are generally legal restrictions on the use and publishing of the activity definition.
    """

    approval_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="approvalDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was approved by the publisher. Approval happens once when the content is officially approved for usage.
    """

    last_review_date: typing_extensions.Annotated[
        typing.Optional[dt.date], FieldMetadata(alias="lastReviewDate")
    ] = pydantic.Field(default=None)
    """
    The date on which the resource content was last reviewed. Review happens periodically after approval but does not change the original approval date.
    """

    effective_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="effectivePeriod")
    ] = pydantic.Field(default=None)
    """
    The period during which the activity definition content was or is planned to be in active use.
    """

    topic: typing.Optional[typing.List[CodeableConcept]] = pydantic.Field(default=None)
    """
    Descriptive topics related to the content of the activity. Topics provide a high-level categorization of the activity that can be useful for filtering and searching.
    """

    author: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individiual or organization primarily involved in the creation and maintenance of the content.
    """

    editor: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for internal coherence of the content.
    """

    reviewer: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization primarily responsible for review of some aspect of the content.
    """

    endorser: typing.Optional[typing.List[ContactDetail]] = pydantic.Field(default=None)
    """
    An individual or organization responsible for officially endorsing the content for use in some setting.
    """

    related_artifact: typing_extensions.Annotated[
        typing.Optional[typing.List[RelatedArtifact]],
        FieldMetadata(alias="relatedArtifact"),
    ] = pydantic.Field(default=None)
    """
    Related artifacts such as additional documentation, justification, or bibliographic references.
    """

    library: typing.Optional[typing.List[Canonical]] = pydantic.Field(default=None)
    """
    A reference to a Library resource containing any formal logic used by the activity definition.
    """

    kind: typing.Optional[Code] = pydantic.Field(default=None)
    """
    A description of the kind of resource the activity definition is representing. For example, a MedicationRequest, a ServiceRequest, or a CommunicationRequest. Typically, but not always, this is a Request resource.
    """

    profile: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    A profile to which the target of the activity definition is expected to conform.
    """

    code: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Detailed description of the type of activity; e.g. What lab test, what procedure, what kind of encounter.
    """

    intent: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates the level of authority/intentionality associated with the activity and where the request should fit into the workflow chain.
    """

    priority: typing.Optional[Code] = pydantic.Field(default=None)
    """
    Indicates how quickly the activity should be addressed with respect to other requests.
    """

    do_not_perform: typing_extensions.Annotated[
        typing.Optional[bool], FieldMetadata(alias="doNotPerform")
    ] = pydantic.Field(default=None)
    """
    Set this to true if the definition is to indicate that a particular activity should NOT be performed. If true, this element should be interpreted to reinforce a negative coding. For example NPO as a code with a doNotPerform of true would still indicate to NOT perform the action.
    """

    timing_timing: typing_extensions.Annotated[
        typing.Optional[Timing], FieldMetadata(alias="timingTiming")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    timing_date_time: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="timingDateTime")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    timing_age: typing_extensions.Annotated[
        typing.Optional[Age], FieldMetadata(alias="timingAge")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    timing_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="timingPeriod")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    timing_range: typing_extensions.Annotated[
        typing.Optional[Range], FieldMetadata(alias="timingRange")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    timing_duration: typing_extensions.Annotated[
        typing.Optional[Duration], FieldMetadata(alias="timingDuration")
    ] = pydantic.Field(default=None)
    """
    The period, timing or frequency upon which the described activity is to occur.
    """

    location: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Identifies the facility where the activity will occur; e.g. home, hospital, specific clinic, etc.
    """

    participant: typing.Optional[typing.List[ActivityDefinitionParticipant]] = (
        pydantic.Field(default=None)
    )
    """
    Indicates who should participate in performing the action described.
    """

    product_reference: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="productReference")
    ] = pydantic.Field(default=None)
    """
    Identifies the food, drug or other product being consumed or supplied in the activity.
    """

    product_codeable_concept: typing_extensions.Annotated[
        typing.Optional[CodeableConcept], FieldMetadata(alias="productCodeableConcept")
    ] = pydantic.Field(default=None)
    """
    Identifies the food, drug or other product being consumed or supplied in the activity.
    """

    quantity: typing.Optional[Quantity] = pydantic.Field(default=None)
    """
    Identifies the quantity expected to be consumed at once (per dose, per meal, etc.).
    """

    dosage: typing.Optional[typing.List[Dosage]] = pydantic.Field(default=None)
    """
    Provides detailed dosage instructions in the same way that they are described for MedicationRequest resources.
    """

    body_site: typing_extensions.Annotated[
        typing.Optional[typing.List[CodeableConcept]], FieldMetadata(alias="bodySite")
    ] = pydantic.Field(default=None)
    """
    Indicates the sites on the subject's body where the procedure should be performed (I.e. the target sites).
    """

    specimen_requirement: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="specimenRequirement"),
    ] = pydantic.Field(default=None)
    """
    Defines specimen requirements for the action to be performed, such as required specimens for a lab test.
    """

    observation_requirement: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="observationRequirement"),
    ] = pydantic.Field(default=None)
    """
    Defines observation requirements for the action to be performed, such as body weight or surface area.
    """

    observation_result_requirement: typing_extensions.Annotated[
        typing.Optional[typing.List[Reference]],
        FieldMetadata(alias="observationResultRequirement"),
    ] = pydantic.Field(default=None)
    """
    Defines the observations that are expected to be produced by the action.
    """

    transform: typing.Optional[Canonical] = pydantic.Field(default=None)
    """
    A reference to a StructureMap resource that defines a transform that can be executed to produce the intent resource using the ActivityDefinition instance as the input.
    """

    dynamic_value: typing_extensions.Annotated[
        typing.Optional[typing.List[ActivityDefinitionDynamicValue]],
        FieldMetadata(alias="dynamicValue"),
    ] = pydantic.Field(default=None)
    """
    Dynamic values that will be evaluated to produce values for elements of the resulting resource. For example, if the dosage of a medication must be computed based on the patient's weight, a dynamic value would be used to specify an expression that calculated the weight, and the path on the request resource that would contain the result.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
