# This file was auto-generated by Fern from our API Definition.

from .base_resource import BaseResource
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing_extensions
import typing
from ...core.serialization import FieldMetadata
import pydantic
from .account_status import AccountStatus
from .account_coverage import AccountCoverage
from .account_guarantor import AccountGuarantor
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Account(BaseResource):
    """
    A financial tool for tracking value accrued for a particular purpose. In the healthcare field, used to track charges for a patient, cost centers, etc.
    """

    resource_type: typing_extensions.Annotated[
        typing.Literal["Account"], FieldMetadata(alias="resourceType")
    ] = "Account"
    identifier: typing.Optional[typing.List[Identifier]] = pydantic.Field(default=None)
    """
    Unique identifier used to reference the account. Might or might not be intended for human use (e.g. credit card number).
    """

    status: typing.Optional[AccountStatus] = pydantic.Field(default=None)
    """
    Indicates whether the account is presently used/usable or not.
    """

    type: typing.Optional[CodeableConcept] = pydantic.Field(default=None)
    """
    Categorizes the account for reporting and searching purposes.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name used for the account when displaying it to humans in reports, etc.
    """

    subject: typing.Optional[typing.List[Reference]] = pydantic.Field(default=None)
    """
    Identifies the entity which incurs the expenses. While the immediate recipients of services or goods might be entities related to the subject, the expenses were ultimately incurred by the subject of the Account.
    """

    service_period: typing_extensions.Annotated[
        typing.Optional[Period], FieldMetadata(alias="servicePeriod")
    ] = pydantic.Field(default=None)
    """
    The date range of services associated with this account.
    """

    coverage: typing.Optional[typing.List[AccountCoverage]] = pydantic.Field(
        default=None
    )
    """
    The party(s) that are responsible for covering the payment of this account, and what order should they be applied to the account.
    """

    owner: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    Indicates the service area, hospital, department, etc. with responsibility for managing the Account.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    Provides additional information about what the account tracks and how it is used.
    """

    guarantor: typing.Optional[typing.List[AccountGuarantor]] = pydantic.Field(
        default=None
    )
    """
    The parties responsible for balancing the account if other payment options fall short.
    """

    part_of: typing_extensions.Annotated[
        typing.Optional[Reference], FieldMetadata(alias="partOf")
    ] = pydantic.Field(default=None)
    """
    Reference to a parent Account.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
