# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
from .address import Address
from .age import Age
from .annotation import Annotation
from .attachment import Attachment
from .codeable_concept import CodeableConcept
from .coding import Coding
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contributor import Contributor
from .count import Count
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .distance import Distance
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .expression import Expression
from .extension import Extension
from .human_name import HumanName
from .identifier import Identifier
from .meta import Meta
from .money import Money
from .parameter_definition import ParameterDefinition
from .period import Period
from .quantity import Quantity
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .sampled_data import SampledData
from .signature import Signature
from .timing import Timing
from .timing_repeat import TimingRepeat
from .trigger_definition import TriggerDefinition
from .usage_context import UsageContext
import typing
import pydantic
import typing_extensions
from ...core.serialization import FieldMetadata
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AccessPolicyResource(UniversalBaseModel):
    """
    Access details for a resource type.
    """

    compartment: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    DEPRECATED Optional compartment restriction for the resource type.
    """

    criteria: typing.Optional[str] = pydantic.Field(default=None)
    """
    The rules that the server should use to determine which resources to allow.
    """

    readonly: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Optional flag to indicate that the resource type is read-only.
    """

    hidden_fields: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="hiddenFields")
    ] = pydantic.Field(default=None)
    """
    Optional list of hidden fields. Hidden fields are not readable or writeable.
    """

    readonly_fields: typing_extensions.Annotated[
        typing.Optional[typing.List[str]], FieldMetadata(alias="readonlyFields")
    ] = pydantic.Field(default=None)
    """
    Optional list of read-only fields. Read-only fields are readable but not writeable.
    """

    write_constraint: typing_extensions.Annotated[
        typing.Optional[typing.List[Expression]], FieldMetadata(alias="writeConstraint")
    ] = pydantic.Field(default=None)
    """
    Invariants that must be satisfied for the resource to be written. Can include %before and %after placeholders to refer to the resource before and after the updates are applied.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
