# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing
import pydantic
from .access_policy_ip_access_rule_action import AccessPolicyIpAccessRuleAction
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class AccessPolicyIpAccessRule(UniversalBaseModel):
    """
    Use IP Access Rules to allowlist, block, and challenge traffic based on the visitor IP address.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Friendly name that will make it easy for you to identify the IP Access Rule in the future.
    """

    value: str = pydantic.Field()
    """
    An IP Access rule will apply a certain action to incoming traffic based on the visitor IP address or IP range.
    """

    action: AccessPolicyIpAccessRuleAction = pydantic.Field()
    """
    Access rule can perform one of the following actions: "allow" | "block".
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
