# This file was auto-generated by Fern from our API Definition.

from .access_policy import AccessPolicy
from .access_policy_ip_access_rule import AccessPolicyIpAccessRule
from .access_policy_ip_access_rule_action import AccessPolicyIpAccessRuleAction
from .access_policy_resource import AccessPolicyResource
from .access_policy_resource_write_criteria import AccessPolicyResourceWriteCriteria
from .account import Account
from .account_coverage import AccountCoverage
from .account_guarantor import AccountGuarantor
from .account_status import AccountStatus
from .activity_definition import ActivityDefinition
from .activity_definition_dynamic_value import ActivityDefinitionDynamicValue
from .activity_definition_participant import ActivityDefinitionParticipant
from .activity_definition_status import ActivityDefinitionStatus
from .address import Address
from .address_type import AddressType
from .address_use import AddressUse
from .adverse_event import AdverseEvent
from .adverse_event_actuality import AdverseEventActuality
from .adverse_event_causality import AdverseEventCausality
from .adverse_event_suspect_entity import AdverseEventSuspectEntity
from .age import Age
from .age_comparator import AgeComparator
from .agent import Agent
from .agent_channel import AgentChannel
from .agent_setting import AgentSetting
from .agent_status import AgentStatus
from .allergy_intolerance import AllergyIntolerance
from .allergy_intolerance_category_item import AllergyIntoleranceCategoryItem
from .allergy_intolerance_criticality import AllergyIntoleranceCriticality
from .allergy_intolerance_reaction import AllergyIntoleranceReaction
from .allergy_intolerance_reaction_severity import AllergyIntoleranceReactionSeverity
from .allergy_intolerance_type import AllergyIntoleranceType
from .annotation import Annotation
from .appointment import Appointment
from .appointment_participant import AppointmentParticipant
from .appointment_participant_required import AppointmentParticipantRequired
from .appointment_participant_status import AppointmentParticipantStatus
from .appointment_response import AppointmentResponse
from .appointment_status import AppointmentStatus
from .async_job import AsyncJob
from .async_job_status import AsyncJobStatus
from .attachment import Attachment
from .audit_event import AuditEvent
from .audit_event_action import AuditEventAction
from .audit_event_agent import AuditEventAgent
from .audit_event_detail import AuditEventDetail
from .audit_event_entity import AuditEventEntity
from .audit_event_network import AuditEventNetwork
from .audit_event_network_type import AuditEventNetworkType
from .audit_event_outcome import AuditEventOutcome
from .audit_event_source import AuditEventSource
from .base_64_binary import Base64Binary
from .base_resource import BaseResource
from .basic import Basic
from .binary import Binary
from .biologically_derived_product import BiologicallyDerivedProduct
from .biologically_derived_product_collection import (
    BiologicallyDerivedProductCollection,
)
from .biologically_derived_product_manipulation import (
    BiologicallyDerivedProductManipulation,
)
from .biologically_derived_product_processing import (
    BiologicallyDerivedProductProcessing,
)
from .biologically_derived_product_product_category import (
    BiologicallyDerivedProductProductCategory,
)
from .biologically_derived_product_status import BiologicallyDerivedProductStatus
from .biologically_derived_product_storage import BiologicallyDerivedProductStorage
from .biologically_derived_product_storage_scale import (
    BiologicallyDerivedProductStorageScale,
)
from .body_structure import BodyStructure
from .boolean import Boolean
from .bot import Bot
from .bot_audit_event_destination_item import BotAuditEventDestinationItem
from .bot_audit_event_trigger import BotAuditEventTrigger
from .bot_runtime_version import BotRuntimeVersion
from .bulk_data_export import BulkDataExport
from .bulk_data_export_deleted import BulkDataExportDeleted
from .bulk_data_export_error import BulkDataExportError
from .bulk_data_export_output import BulkDataExportOutput
from .bulk_data_export_status import BulkDataExportStatus
from .bundle import Bundle
from .bundle_entry import BundleEntry
from .bundle_link import BundleLink
from .bundle_request import BundleRequest
from .bundle_request_method import BundleRequestMethod
from .bundle_response import BundleResponse
from .bundle_search import BundleSearch
from .bundle_search_mode import BundleSearchMode
from .bundle_type import BundleType
from .canonical import Canonical
from .capability_statement import CapabilityStatement
from .capability_statement_document import CapabilityStatementDocument
from .capability_statement_document_mode import CapabilityStatementDocumentMode
from .capability_statement_endpoint import CapabilityStatementEndpoint
from .capability_statement_fhir_version import CapabilityStatementFhirVersion
from .capability_statement_implementation import CapabilityStatementImplementation
from .capability_statement_interaction import CapabilityStatementInteraction
from .capability_statement_interaction_1 import CapabilityStatementInteraction1
from .capability_statement_interaction_1_code import CapabilityStatementInteraction1Code
from .capability_statement_interaction_code import CapabilityStatementInteractionCode
from .capability_statement_kind import CapabilityStatementKind
from .capability_statement_messaging import CapabilityStatementMessaging
from .capability_statement_operation import CapabilityStatementOperation
from .capability_statement_resource import CapabilityStatementResource
from .capability_statement_resource_conditional_delete import (
    CapabilityStatementResourceConditionalDelete,
)
from .capability_statement_resource_conditional_read import (
    CapabilityStatementResourceConditionalRead,
)
from .capability_statement_resource_reference_policy_item import (
    CapabilityStatementResourceReferencePolicyItem,
)
from .capability_statement_resource_versioning import (
    CapabilityStatementResourceVersioning,
)
from .capability_statement_rest import CapabilityStatementRest
from .capability_statement_rest_mode import CapabilityStatementRestMode
from .capability_statement_search_param import CapabilityStatementSearchParam
from .capability_statement_search_param_type import CapabilityStatementSearchParamType
from .capability_statement_security import CapabilityStatementSecurity
from .capability_statement_software import CapabilityStatementSoftware
from .capability_statement_status import CapabilityStatementStatus
from .capability_statement_supported_message import CapabilityStatementSupportedMessage
from .capability_statement_supported_message_mode import (
    CapabilityStatementSupportedMessageMode,
)
from .care_plan import CarePlan
from .care_plan_activity import CarePlanActivity
from .care_plan_detail import CarePlanDetail
from .care_plan_detail_status import CarePlanDetailStatus
from .care_team import CareTeam
from .care_team_participant import CareTeamParticipant
from .care_team_status import CareTeamStatus
from .catalog_entry import CatalogEntry
from .catalog_entry_related_entry import CatalogEntryRelatedEntry
from .catalog_entry_related_entry_relationtype import (
    CatalogEntryRelatedEntryRelationtype,
)
from .catalog_entry_status import CatalogEntryStatus
from .charge_item import ChargeItem
from .charge_item_definition import ChargeItemDefinition
from .charge_item_definition_applicability import ChargeItemDefinitionApplicability
from .charge_item_definition_price_component import ChargeItemDefinitionPriceComponent
from .charge_item_definition_property_group import ChargeItemDefinitionPropertyGroup
from .charge_item_definition_status import ChargeItemDefinitionStatus
from .charge_item_performer import ChargeItemPerformer
from .charge_item_status import ChargeItemStatus
from .claim import Claim
from .claim_accident import ClaimAccident
from .claim_care_team import ClaimCareTeam
from .claim_detail import ClaimDetail
from .claim_diagnosis import ClaimDiagnosis
from .claim_insurance import ClaimInsurance
from .claim_item import ClaimItem
from .claim_payee import ClaimPayee
from .claim_procedure import ClaimProcedure
from .claim_related import ClaimRelated
from .claim_response import ClaimResponse
from .claim_response_add_item import ClaimResponseAddItem
from .claim_response_adjudication import ClaimResponseAdjudication
from .claim_response_detail import ClaimResponseDetail
from .claim_response_detail_1 import ClaimResponseDetail1
from .claim_response_error import ClaimResponseError
from .claim_response_insurance import ClaimResponseInsurance
from .claim_response_item import ClaimResponseItem
from .claim_response_payment import ClaimResponsePayment
from .claim_response_process_note import ClaimResponseProcessNote
from .claim_response_process_note_type import ClaimResponseProcessNoteType
from .claim_response_sub_detail import ClaimResponseSubDetail
from .claim_response_sub_detail_1 import ClaimResponseSubDetail1
from .claim_response_total import ClaimResponseTotal
from .claim_sub_detail import ClaimSubDetail
from .claim_supporting_info import ClaimSupportingInfo
from .claim_use import ClaimUse
from .client_application import ClientApplication
from .clinical_impression import ClinicalImpression
from .clinical_impression_finding import ClinicalImpressionFinding
from .clinical_impression_investigation import ClinicalImpressionInvestigation
from .code import Code
from .code_system import CodeSystem
from .code_system_concept import CodeSystemConcept
from .code_system_content import CodeSystemContent
from .code_system_designation import CodeSystemDesignation
from .code_system_filter import CodeSystemFilter
from .code_system_hierarchy_meaning import CodeSystemHierarchyMeaning
from .code_system_property import CodeSystemProperty
from .code_system_property_1 import CodeSystemProperty1
from .code_system_property_type import CodeSystemPropertyType
from .code_system_status import CodeSystemStatus
from .codeable_concept import CodeableConcept
from .coding import Coding
from .communication import Communication
from .communication_payload import CommunicationPayload
from .communication_request import CommunicationRequest
from .communication_request_payload import CommunicationRequestPayload
from .compartment_definition import CompartmentDefinition
from .compartment_definition_code import CompartmentDefinitionCode
from .compartment_definition_resource import CompartmentDefinitionResource
from .compartment_definition_status import CompartmentDefinitionStatus
from .composition import Composition
from .composition_attester import CompositionAttester
from .composition_attester_mode import CompositionAttesterMode
from .composition_event import CompositionEvent
from .composition_relates_to import CompositionRelatesTo
from .composition_section import CompositionSection
from .composition_status import CompositionStatus
from .concept_map import ConceptMap
from .concept_map_depends_on import ConceptMapDependsOn
from .concept_map_element import ConceptMapElement
from .concept_map_group import ConceptMapGroup
from .concept_map_status import ConceptMapStatus
from .concept_map_target import ConceptMapTarget
from .concept_map_target_equivalence import ConceptMapTargetEquivalence
from .concept_map_unmapped import ConceptMapUnmapped
from .concept_map_unmapped_mode import ConceptMapUnmappedMode
from .condition import Condition
from .condition_evidence import ConditionEvidence
from .condition_stage import ConditionStage
from .consent import Consent
from .consent_actor import ConsentActor
from .consent_data import ConsentData
from .consent_data_meaning import ConsentDataMeaning
from .consent_policy import ConsentPolicy
from .consent_provision import ConsentProvision
from .consent_provision_type import ConsentProvisionType
from .consent_status import ConsentStatus
from .consent_verification import ConsentVerification
from .contact_detail import ContactDetail
from .contact_point import ContactPoint
from .contact_point_system import ContactPointSystem
from .contact_point_use import ContactPointUse
from .contract import Contract
from .contract_action import ContractAction
from .contract_answer import ContractAnswer
from .contract_asset import ContractAsset
from .contract_content_definition import ContractContentDefinition
from .contract_context import ContractContext
from .contract_friendly import ContractFriendly
from .contract_legal import ContractLegal
from .contract_offer import ContractOffer
from .contract_party import ContractParty
from .contract_rule import ContractRule
from .contract_security_label import ContractSecurityLabel
from .contract_signer import ContractSigner
from .contract_subject import ContractSubject
from .contract_term import ContractTerm
from .contract_valued_item import ContractValuedItem
from .contributor import Contributor
from .contributor_type import ContributorType
from .count import Count
from .count_comparator import CountComparator
from .coverage import Coverage
from .coverage_class import CoverageClass
from .coverage_cost_to_beneficiary import CoverageCostToBeneficiary
from .coverage_eligibility_request import CoverageEligibilityRequest
from .coverage_eligibility_request_diagnosis import CoverageEligibilityRequestDiagnosis
from .coverage_eligibility_request_insurance import CoverageEligibilityRequestInsurance
from .coverage_eligibility_request_item import CoverageEligibilityRequestItem
from .coverage_eligibility_request_purpose_item import (
    CoverageEligibilityRequestPurposeItem,
)
from .coverage_eligibility_request_supporting_info import (
    CoverageEligibilityRequestSupportingInfo,
)
from .coverage_eligibility_response import CoverageEligibilityResponse
from .coverage_eligibility_response_benefit import CoverageEligibilityResponseBenefit
from .coverage_eligibility_response_error import CoverageEligibilityResponseError
from .coverage_eligibility_response_insurance import (
    CoverageEligibilityResponseInsurance,
)
from .coverage_eligibility_response_item import CoverageEligibilityResponseItem
from .coverage_eligibility_response_outcome import CoverageEligibilityResponseOutcome
from .coverage_eligibility_response_purpose_item import (
    CoverageEligibilityResponsePurposeItem,
)
from .coverage_exception import CoverageException
from .data_requirement import DataRequirement
from .data_requirement_code_filter import DataRequirementCodeFilter
from .data_requirement_date_filter import DataRequirementDateFilter
from .data_requirement_sort import DataRequirementSort
from .data_requirement_sort_direction import DataRequirementSortDirection
from .date import Date
from .date_time import DateTime
from .decimal import Decimal
from .detected_issue import DetectedIssue
from .detected_issue_evidence import DetectedIssueEvidence
from .detected_issue_mitigation import DetectedIssueMitigation
from .detected_issue_severity import DetectedIssueSeverity
from .device import Device
from .device_definition import DeviceDefinition
from .device_definition_capability import DeviceDefinitionCapability
from .device_definition_classification import DeviceDefinitionClassification
from .device_definition_device_name import DeviceDefinitionDeviceName
from .device_definition_device_name_type import DeviceDefinitionDeviceNameType
from .device_definition_material import DeviceDefinitionMaterial
from .device_definition_property import DeviceDefinitionProperty
from .device_definition_specialization import DeviceDefinitionSpecialization
from .device_definition_udi_device_identifier import DeviceDefinitionUdiDeviceIdentifier
from .device_device_name import DeviceDeviceName
from .device_device_name_type import DeviceDeviceNameType
from .device_metric import DeviceMetric
from .device_metric_calibration import DeviceMetricCalibration
from .device_metric_calibration_state import DeviceMetricCalibrationState
from .device_metric_calibration_type import DeviceMetricCalibrationType
from .device_metric_category import DeviceMetricCategory
from .device_metric_color import DeviceMetricColor
from .device_metric_operational_status import DeviceMetricOperationalStatus
from .device_property import DeviceProperty
from .device_request import DeviceRequest
from .device_request_parameter import DeviceRequestParameter
from .device_specialization import DeviceSpecialization
from .device_status import DeviceStatus
from .device_udi_carrier import DeviceUdiCarrier
from .device_udi_carrier_entry_type import DeviceUdiCarrierEntryType
from .device_use_statement import DeviceUseStatement
from .device_use_statement_status import DeviceUseStatementStatus
from .device_version import DeviceVersion
from .diagnostic_report import DiagnosticReport
from .diagnostic_report_media import DiagnosticReportMedia
from .diagnostic_report_status import DiagnosticReportStatus
from .distance import Distance
from .distance_comparator import DistanceComparator
from .document_manifest import DocumentManifest
from .document_manifest_related import DocumentManifestRelated
from .document_manifest_status import DocumentManifestStatus
from .document_reference import DocumentReference
from .document_reference_content import DocumentReferenceContent
from .document_reference_context import DocumentReferenceContext
from .document_reference_relates_to import DocumentReferenceRelatesTo
from .document_reference_relates_to_code import DocumentReferenceRelatesToCode
from .document_reference_status import DocumentReferenceStatus
from .domain_configuration import DomainConfiguration
from .dosage import Dosage
from .dosage_dose_and_rate import DosageDoseAndRate
from .duration import Duration
from .duration_comparator import DurationComparator
from .effect_evidence_synthesis import EffectEvidenceSynthesis
from .effect_evidence_synthesis_certainty import EffectEvidenceSynthesisCertainty
from .effect_evidence_synthesis_certainty_subcomponent import (
    EffectEvidenceSynthesisCertaintySubcomponent,
)
from .effect_evidence_synthesis_effect_estimate import (
    EffectEvidenceSynthesisEffectEstimate,
)
from .effect_evidence_synthesis_precision_estimate import (
    EffectEvidenceSynthesisPrecisionEstimate,
)
from .effect_evidence_synthesis_results_by_exposure import (
    EffectEvidenceSynthesisResultsByExposure,
)
from .effect_evidence_synthesis_results_by_exposure_exposure_state import (
    EffectEvidenceSynthesisResultsByExposureExposureState,
)
from .effect_evidence_synthesis_sample_size import EffectEvidenceSynthesisSampleSize
from .effect_evidence_synthesis_status import EffectEvidenceSynthesisStatus
from .element import Element
from .element_definition import ElementDefinition
from .element_definition_base import ElementDefinitionBase
from .element_definition_binding import ElementDefinitionBinding
from .element_definition_binding_strength import ElementDefinitionBindingStrength
from .element_definition_constraint import ElementDefinitionConstraint
from .element_definition_constraint_severity import ElementDefinitionConstraintSeverity
from .element_definition_discriminator import ElementDefinitionDiscriminator
from .element_definition_discriminator_type import ElementDefinitionDiscriminatorType
from .element_definition_example import ElementDefinitionExample
from .element_definition_mapping import ElementDefinitionMapping
from .element_definition_representation_item import ElementDefinitionRepresentationItem
from .element_definition_slicing import ElementDefinitionSlicing
from .element_definition_slicing_rules import ElementDefinitionSlicingRules
from .element_definition_type import ElementDefinitionType
from .element_definition_type_aggregation_item import (
    ElementDefinitionTypeAggregationItem,
)
from .element_definition_type_versioning import ElementDefinitionTypeVersioning
from .encounter import Encounter
from .encounter_class_history import EncounterClassHistory
from .encounter_diagnosis import EncounterDiagnosis
from .encounter_hospitalization import EncounterHospitalization
from .encounter_location import EncounterLocation
from .encounter_location_status import EncounterLocationStatus
from .encounter_participant import EncounterParticipant
from .encounter_status import EncounterStatus
from .encounter_status_history import EncounterStatusHistory
from .encounter_status_history_status import EncounterStatusHistoryStatus
from .endpoint import Endpoint
from .endpoint_status import EndpointStatus
from .enrollment_request import EnrollmentRequest
from .enrollment_response import EnrollmentResponse
from .enrollment_response_outcome import EnrollmentResponseOutcome
from .episode_of_care import EpisodeOfCare
from .episode_of_care_diagnosis import EpisodeOfCareDiagnosis
from .episode_of_care_status import EpisodeOfCareStatus
from .episode_of_care_status_history import EpisodeOfCareStatusHistory
from .episode_of_care_status_history_status import EpisodeOfCareStatusHistoryStatus
from .event_definition import EventDefinition
from .event_definition_status import EventDefinitionStatus
from .evidence import Evidence
from .evidence_status import EvidenceStatus
from .evidence_variable import EvidenceVariable
from .evidence_variable_characteristic import EvidenceVariableCharacteristic
from .evidence_variable_characteristic_group_measure import (
    EvidenceVariableCharacteristicGroupMeasure,
)
from .evidence_variable_status import EvidenceVariableStatus
from .evidence_variable_type import EvidenceVariableType
from .example_scenario import ExampleScenario
from .example_scenario_actor import ExampleScenarioActor
from .example_scenario_actor_type import ExampleScenarioActorType
from .example_scenario_alternative import ExampleScenarioAlternative
from .example_scenario_contained_instance import ExampleScenarioContainedInstance
from .example_scenario_instance import ExampleScenarioInstance
from .example_scenario_operation import ExampleScenarioOperation
from .example_scenario_process import ExampleScenarioProcess
from .example_scenario_status import ExampleScenarioStatus
from .example_scenario_step import ExampleScenarioStep
from .example_scenario_version import ExampleScenarioVersion
from .explanation_of_benefit import ExplanationOfBenefit
from .explanation_of_benefit_accident import ExplanationOfBenefitAccident
from .explanation_of_benefit_add_item import ExplanationOfBenefitAddItem
from .explanation_of_benefit_adjudication import ExplanationOfBenefitAdjudication
from .explanation_of_benefit_benefit_balance import ExplanationOfBenefitBenefitBalance
from .explanation_of_benefit_care_team import ExplanationOfBenefitCareTeam
from .explanation_of_benefit_detail import ExplanationOfBenefitDetail
from .explanation_of_benefit_detail_1 import ExplanationOfBenefitDetail1
from .explanation_of_benefit_diagnosis import ExplanationOfBenefitDiagnosis
from .explanation_of_benefit_financial import ExplanationOfBenefitFinancial
from .explanation_of_benefit_insurance import ExplanationOfBenefitInsurance
from .explanation_of_benefit_item import ExplanationOfBenefitItem
from .explanation_of_benefit_payee import ExplanationOfBenefitPayee
from .explanation_of_benefit_payment import ExplanationOfBenefitPayment
from .explanation_of_benefit_procedure import ExplanationOfBenefitProcedure
from .explanation_of_benefit_process_note import ExplanationOfBenefitProcessNote
from .explanation_of_benefit_process_note_type import (
    ExplanationOfBenefitProcessNoteType,
)
from .explanation_of_benefit_related import ExplanationOfBenefitRelated
from .explanation_of_benefit_status import ExplanationOfBenefitStatus
from .explanation_of_benefit_sub_detail import ExplanationOfBenefitSubDetail
from .explanation_of_benefit_sub_detail_1 import ExplanationOfBenefitSubDetail1
from .explanation_of_benefit_supporting_info import ExplanationOfBenefitSupportingInfo
from .explanation_of_benefit_total import ExplanationOfBenefitTotal
from .expression import Expression
from .expression_language import ExpressionLanguage
from .extension import Extension
from .family_member_history import FamilyMemberHistory
from .family_member_history_condition import FamilyMemberHistoryCondition
from .family_member_history_status import FamilyMemberHistoryStatus
from .flag import Flag
from .flag_status import FlagStatus
from .goal import Goal
from .goal_lifecycle_status import GoalLifecycleStatus
from .goal_target import GoalTarget
from .graph_definition import GraphDefinition
from .graph_definition_compartment import GraphDefinitionCompartment
from .graph_definition_compartment_rule import GraphDefinitionCompartmentRule
from .graph_definition_compartment_use import GraphDefinitionCompartmentUse
from .graph_definition_link import GraphDefinitionLink
from .graph_definition_status import GraphDefinitionStatus
from .graph_definition_target import GraphDefinitionTarget
from .group import Group
from .group_characteristic import GroupCharacteristic
from .group_member import GroupMember
from .group_type import GroupType
from .guidance_response import GuidanceResponse
from .guidance_response_status import GuidanceResponseStatus
from .healthcare_service import HealthcareService
from .healthcare_service_available_time import HealthcareServiceAvailableTime
from .healthcare_service_available_time_days_of_week_item import (
    HealthcareServiceAvailableTimeDaysOfWeekItem,
)
from .healthcare_service_eligibility import HealthcareServiceEligibility
from .healthcare_service_not_available import HealthcareServiceNotAvailable
from .human_name import HumanName
from .human_name_use import HumanNameUse
from .id import Id
from .identifier import Identifier
from .identifier_use import IdentifierUse
from .identity_provider import IdentityProvider
from .imaging_study import ImagingStudy
from .imaging_study_instance import ImagingStudyInstance
from .imaging_study_performer import ImagingStudyPerformer
from .imaging_study_series import ImagingStudySeries
from .imaging_study_status import ImagingStudyStatus
from .immunization import Immunization
from .immunization_education import ImmunizationEducation
from .immunization_evaluation import ImmunizationEvaluation
from .immunization_performer import ImmunizationPerformer
from .immunization_protocol_applied import ImmunizationProtocolApplied
from .immunization_reaction import ImmunizationReaction
from .immunization_recommendation import ImmunizationRecommendation
from .immunization_recommendation_date_criterion import (
    ImmunizationRecommendationDateCriterion,
)
from .immunization_recommendation_recommendation import (
    ImmunizationRecommendationRecommendation,
)
from .implementation_guide import ImplementationGuide
from .implementation_guide_definition import ImplementationGuideDefinition
from .implementation_guide_depends_on import ImplementationGuideDependsOn
from .implementation_guide_fhir_version_item import ImplementationGuideFhirVersionItem
from .implementation_guide_global import ImplementationGuideGlobal
from .implementation_guide_grouping import ImplementationGuideGrouping
from .implementation_guide_license import ImplementationGuideLicense
from .implementation_guide_manifest import ImplementationGuideManifest
from .implementation_guide_page import ImplementationGuidePage
from .implementation_guide_page_1 import ImplementationGuidePage1
from .implementation_guide_page_generation import ImplementationGuidePageGeneration
from .implementation_guide_parameter import ImplementationGuideParameter
from .implementation_guide_parameter_code import ImplementationGuideParameterCode
from .implementation_guide_resource import ImplementationGuideResource
from .implementation_guide_resource_1 import ImplementationGuideResource1
from .implementation_guide_resource_fhir_version_item import (
    ImplementationGuideResourceFhirVersionItem,
)
from .implementation_guide_status import ImplementationGuideStatus
from .implementation_guide_template import ImplementationGuideTemplate
from .instant import Instant
from .insurance_plan import InsurancePlan
from .insurance_plan_benefit import InsurancePlanBenefit
from .insurance_plan_benefit_1 import InsurancePlanBenefit1
from .insurance_plan_contact import InsurancePlanContact
from .insurance_plan_cost import InsurancePlanCost
from .insurance_plan_coverage import InsurancePlanCoverage
from .insurance_plan_general_cost import InsurancePlanGeneralCost
from .insurance_plan_limit import InsurancePlanLimit
from .insurance_plan_plan import InsurancePlanPlan
from .insurance_plan_specific_cost import InsurancePlanSpecificCost
from .insurance_plan_status import InsurancePlanStatus
from .integer import Integer
from .invoice import Invoice
from .invoice_line_item import InvoiceLineItem
from .invoice_participant import InvoiceParticipant
from .invoice_price_component import InvoicePriceComponent
from .invoice_price_component_type import InvoicePriceComponentType
from .invoice_status import InvoiceStatus
from .json_web_key import JsonWebKey
from .library import Library
from .library_status import LibraryStatus
from .linkage import Linkage
from .linkage_item import LinkageItem
from .linkage_item_type import LinkageItemType
from .list_ import List
from .list_entry import ListEntry
from .list_mode import ListMode
from .list_status import ListStatus
from .location import Location
from .location_hours_of_operation import LocationHoursOfOperation
from .location_mode import LocationMode
from .location_position import LocationPosition
from .location_status import LocationStatus
from .login import Login
from .login_auth_method import LoginAuthMethod
from .login_code_challenge_method import LoginCodeChallengeMethod
from .markdown import Markdown
from .marketing_status import MarketingStatus
from .measure import Measure
from .measure_component import MeasureComponent
from .measure_group import MeasureGroup
from .measure_population import MeasurePopulation
from .measure_report import MeasureReport
from .measure_report_component import MeasureReportComponent
from .measure_report_group import MeasureReportGroup
from .measure_report_population import MeasureReportPopulation
from .measure_report_population_1 import MeasureReportPopulation1
from .measure_report_status import MeasureReportStatus
from .measure_report_stratifier import MeasureReportStratifier
from .measure_report_stratum import MeasureReportStratum
from .measure_report_type import MeasureReportType
from .measure_status import MeasureStatus
from .measure_stratifier import MeasureStratifier
from .measure_supplemental_data import MeasureSupplementalData
from .media import Media
from .medication import Medication
from .medication_administration import MedicationAdministration
from .medication_administration_dosage import MedicationAdministrationDosage
from .medication_administration_performer import MedicationAdministrationPerformer
from .medication_batch import MedicationBatch
from .medication_dispense import MedicationDispense
from .medication_dispense_performer import MedicationDispensePerformer
from .medication_dispense_substitution import MedicationDispenseSubstitution
from .medication_ingredient import MedicationIngredient
from .medication_knowledge import MedicationKnowledge
from .medication_knowledge_administration_guidelines import (
    MedicationKnowledgeAdministrationGuidelines,
)
from .medication_knowledge_cost import MedicationKnowledgeCost
from .medication_knowledge_dosage import MedicationKnowledgeDosage
from .medication_knowledge_drug_characteristic import (
    MedicationKnowledgeDrugCharacteristic,
)
from .medication_knowledge_ingredient import MedicationKnowledgeIngredient
from .medication_knowledge_kinetics import MedicationKnowledgeKinetics
from .medication_knowledge_max_dispense import MedicationKnowledgeMaxDispense
from .medication_knowledge_medicine_classification import (
    MedicationKnowledgeMedicineClassification,
)
from .medication_knowledge_monitoring_program import (
    MedicationKnowledgeMonitoringProgram,
)
from .medication_knowledge_monograph import MedicationKnowledgeMonograph
from .medication_knowledge_packaging import MedicationKnowledgePackaging
from .medication_knowledge_patient_characteristics import (
    MedicationKnowledgePatientCharacteristics,
)
from .medication_knowledge_regulatory import MedicationKnowledgeRegulatory
from .medication_knowledge_related_medication_knowledge import (
    MedicationKnowledgeRelatedMedicationKnowledge,
)
from .medication_knowledge_schedule import MedicationKnowledgeSchedule
from .medication_knowledge_substitution import MedicationKnowledgeSubstitution
from .medication_request import MedicationRequest
from .medication_request_dispense_request import MedicationRequestDispenseRequest
from .medication_request_initial_fill import MedicationRequestInitialFill
from .medication_request_substitution import MedicationRequestSubstitution
from .medication_statement import MedicationStatement
from .medicinal_product import MedicinalProduct
from .medicinal_product_authorization import MedicinalProductAuthorization
from .medicinal_product_authorization_jurisdictional_authorization import (
    MedicinalProductAuthorizationJurisdictionalAuthorization,
)
from .medicinal_product_authorization_procedure import (
    MedicinalProductAuthorizationProcedure,
)
from .medicinal_product_contraindication import MedicinalProductContraindication
from .medicinal_product_contraindication_other_therapy import (
    MedicinalProductContraindicationOtherTherapy,
)
from .medicinal_product_country_language import MedicinalProductCountryLanguage
from .medicinal_product_indication import MedicinalProductIndication
from .medicinal_product_indication_other_therapy import (
    MedicinalProductIndicationOtherTherapy,
)
from .medicinal_product_ingredient import MedicinalProductIngredient
from .medicinal_product_ingredient_reference_strength import (
    MedicinalProductIngredientReferenceStrength,
)
from .medicinal_product_ingredient_specified_substance import (
    MedicinalProductIngredientSpecifiedSubstance,
)
from .medicinal_product_ingredient_strength import MedicinalProductIngredientStrength
from .medicinal_product_ingredient_substance import MedicinalProductIngredientSubstance
from .medicinal_product_interaction import MedicinalProductInteraction
from .medicinal_product_interaction_interactant import (
    MedicinalProductInteractionInteractant,
)
from .medicinal_product_manufactured import MedicinalProductManufactured
from .medicinal_product_manufacturing_business_operation import (
    MedicinalProductManufacturingBusinessOperation,
)
from .medicinal_product_name import MedicinalProductName
from .medicinal_product_name_part import MedicinalProductNamePart
from .medicinal_product_packaged import MedicinalProductPackaged
from .medicinal_product_packaged_batch_identifier import (
    MedicinalProductPackagedBatchIdentifier,
)
from .medicinal_product_packaged_package_item import MedicinalProductPackagedPackageItem
from .medicinal_product_pharmaceutical import MedicinalProductPharmaceutical
from .medicinal_product_pharmaceutical_characteristics import (
    MedicinalProductPharmaceuticalCharacteristics,
)
from .medicinal_product_pharmaceutical_route_of_administration import (
    MedicinalProductPharmaceuticalRouteOfAdministration,
)
from .medicinal_product_pharmaceutical_target_species import (
    MedicinalProductPharmaceuticalTargetSpecies,
)
from .medicinal_product_pharmaceutical_withdrawal_period import (
    MedicinalProductPharmaceuticalWithdrawalPeriod,
)
from .medicinal_product_special_designation import MedicinalProductSpecialDesignation
from .medicinal_product_undesirable_effect import MedicinalProductUndesirableEffect
from .message_definition import MessageDefinition
from .message_definition_allowed_response import MessageDefinitionAllowedResponse
from .message_definition_category import MessageDefinitionCategory
from .message_definition_focus import MessageDefinitionFocus
from .message_definition_response_required import MessageDefinitionResponseRequired
from .message_definition_status import MessageDefinitionStatus
from .message_header import MessageHeader
from .message_header_destination import MessageHeaderDestination
from .message_header_response import MessageHeaderResponse
from .message_header_response_code import MessageHeaderResponseCode
from .message_header_source import MessageHeaderSource
from .meta import Meta
from .molecular_sequence import MolecularSequence
from .molecular_sequence_inner import MolecularSequenceInner
from .molecular_sequence_outer import MolecularSequenceOuter
from .molecular_sequence_quality import MolecularSequenceQuality
from .molecular_sequence_quality_type import MolecularSequenceQualityType
from .molecular_sequence_reference_seq import MolecularSequenceReferenceSeq
from .molecular_sequence_reference_seq_orientation import (
    MolecularSequenceReferenceSeqOrientation,
)
from .molecular_sequence_reference_seq_strand import MolecularSequenceReferenceSeqStrand
from .molecular_sequence_repository import MolecularSequenceRepository
from .molecular_sequence_repository_type import MolecularSequenceRepositoryType
from .molecular_sequence_roc import MolecularSequenceRoc
from .molecular_sequence_structure_variant import MolecularSequenceStructureVariant
from .molecular_sequence_type import MolecularSequenceType
from .molecular_sequence_variant import MolecularSequenceVariant
from .money import Money
from .naming_system import NamingSystem
from .naming_system_kind import NamingSystemKind
from .naming_system_status import NamingSystemStatus
from .naming_system_unique_id import NamingSystemUniqueId
from .naming_system_unique_id_type import NamingSystemUniqueIdType
from .narrative import Narrative
from .narrative_status import NarrativeStatus
from .nutrition_order import NutritionOrder
from .nutrition_order_administration import NutritionOrderAdministration
from .nutrition_order_enteral_formula import NutritionOrderEnteralFormula
from .nutrition_order_nutrient import NutritionOrderNutrient
from .nutrition_order_oral_diet import NutritionOrderOralDiet
from .nutrition_order_supplement import NutritionOrderSupplement
from .nutrition_order_texture import NutritionOrderTexture
from .observation import Observation
from .observation_component import ObservationComponent
from .observation_definition import ObservationDefinition
from .observation_definition_permitted_data_type_item import (
    ObservationDefinitionPermittedDataTypeItem,
)
from .observation_definition_qualified_interval import (
    ObservationDefinitionQualifiedInterval,
)
from .observation_definition_qualified_interval_category import (
    ObservationDefinitionQualifiedIntervalCategory,
)
from .observation_definition_qualified_interval_gender import (
    ObservationDefinitionQualifiedIntervalGender,
)
from .observation_definition_quantitative_details import (
    ObservationDefinitionQuantitativeDetails,
)
from .observation_reference_range import ObservationReferenceRange
from .observation_status import ObservationStatus
from .oid import Oid
from .operation_definition import OperationDefinition
from .operation_definition_binding import OperationDefinitionBinding
from .operation_definition_binding_strength import OperationDefinitionBindingStrength
from .operation_definition_kind import OperationDefinitionKind
from .operation_definition_overload import OperationDefinitionOverload
from .operation_definition_parameter import OperationDefinitionParameter
from .operation_definition_parameter_search_type import (
    OperationDefinitionParameterSearchType,
)
from .operation_definition_parameter_use import OperationDefinitionParameterUse
from .operation_definition_referenced_from import OperationDefinitionReferencedFrom
from .operation_definition_status import OperationDefinitionStatus
from .operation_outcome import OperationOutcome
from .operation_outcome_issue import OperationOutcomeIssue
from .operation_outcome_issue_code import OperationOutcomeIssueCode
from .operation_outcome_issue_severity import OperationOutcomeIssueSeverity
from .organization import Organization
from .organization_affiliation import OrganizationAffiliation
from .organization_contact import OrganizationContact
from .parameter_definition import ParameterDefinition
from .parameters import Parameters
from .parameters_parameter import ParametersParameter
from .password_change_request import PasswordChangeRequest
from .password_change_request_type import PasswordChangeRequestType
from .patient import Patient
from .patient_communication import PatientCommunication
from .patient_contact import PatientContact
from .patient_contact_gender import PatientContactGender
from .patient_gender import PatientGender
from .patient_link import PatientLink
from .patient_link_type import PatientLinkType
from .payment_notice import PaymentNotice
from .payment_reconciliation import PaymentReconciliation
from .payment_reconciliation_detail import PaymentReconciliationDetail
from .payment_reconciliation_outcome import PaymentReconciliationOutcome
from .payment_reconciliation_process_note import PaymentReconciliationProcessNote
from .payment_reconciliation_process_note_type import (
    PaymentReconciliationProcessNoteType,
)
from .period import Period
from .person import Person
from .person_gender import PersonGender
from .person_link import PersonLink
from .person_link_assurance import PersonLinkAssurance
from .plan_definition import PlanDefinition
from .plan_definition_action import PlanDefinitionAction
from .plan_definition_action_cardinality_behavior import (
    PlanDefinitionActionCardinalityBehavior,
)
from .plan_definition_action_grouping_behavior import (
    PlanDefinitionActionGroupingBehavior,
)
from .plan_definition_action_precheck_behavior import (
    PlanDefinitionActionPrecheckBehavior,
)
from .plan_definition_action_required_behavior import (
    PlanDefinitionActionRequiredBehavior,
)
from .plan_definition_action_selection_behavior import (
    PlanDefinitionActionSelectionBehavior,
)
from .plan_definition_condition import PlanDefinitionCondition
from .plan_definition_condition_kind import PlanDefinitionConditionKind
from .plan_definition_dynamic_value import PlanDefinitionDynamicValue
from .plan_definition_goal import PlanDefinitionGoal
from .plan_definition_participant import PlanDefinitionParticipant
from .plan_definition_participant_type import PlanDefinitionParticipantType
from .plan_definition_related_action import PlanDefinitionRelatedAction
from .plan_definition_related_action_relationship import (
    PlanDefinitionRelatedActionRelationship,
)
from .plan_definition_status import PlanDefinitionStatus
from .plan_definition_target import PlanDefinitionTarget
from .population import Population
from .positive_int import PositiveInt
from .practitioner import Practitioner
from .practitioner_gender import PractitionerGender
from .practitioner_qualification import PractitionerQualification
from .practitioner_role import PractitionerRole
from .practitioner_role_available_time import PractitionerRoleAvailableTime
from .practitioner_role_not_available import PractitionerRoleNotAvailable
from .procedure import Procedure
from .procedure_focal_device import ProcedureFocalDevice
from .procedure_performer import ProcedurePerformer
from .prod_characteristic import ProdCharacteristic
from .product_shelf_life import ProductShelfLife
from .project import Project
from .project_features_item import ProjectFeaturesItem
from .project_membership import ProjectMembership
from .project_membership_access import ProjectMembershipAccess
from .project_membership_access_parameter import ProjectMembershipAccessParameter
from .project_secret import ProjectSecret
from .project_site import ProjectSite
from .provenance import Provenance
from .provenance_agent import ProvenanceAgent
from .provenance_entity import ProvenanceEntity
from .provenance_entity_role import ProvenanceEntityRole
from .quantity import Quantity
from .quantity_comparator import QuantityComparator
from .questionnaire import Questionnaire
from .questionnaire_answer_option import QuestionnaireAnswerOption
from .questionnaire_enable_when import QuestionnaireEnableWhen
from .questionnaire_enable_when_operator import QuestionnaireEnableWhenOperator
from .questionnaire_initial import QuestionnaireInitial
from .questionnaire_item import QuestionnaireItem
from .questionnaire_item_enable_behavior import QuestionnaireItemEnableBehavior
from .questionnaire_item_type import QuestionnaireItemType
from .questionnaire_response import QuestionnaireResponse
from .questionnaire_response_answer import QuestionnaireResponseAnswer
from .questionnaire_response_item import QuestionnaireResponseItem
from .questionnaire_response_status import QuestionnaireResponseStatus
from .questionnaire_status import QuestionnaireStatus
from .range import Range
from .ratio import Ratio
from .reference import Reference
from .related_artifact import RelatedArtifact
from .related_artifact_type import RelatedArtifactType
from .related_person import RelatedPerson
from .related_person_communication import RelatedPersonCommunication
from .related_person_gender import RelatedPersonGender
from .request_group import RequestGroup
from .request_group_action import RequestGroupAction
from .request_group_condition import RequestGroupCondition
from .request_group_related_action import RequestGroupRelatedAction
from .research_definition import ResearchDefinition
from .research_definition_status import ResearchDefinitionStatus
from .research_element_definition import ResearchElementDefinition
from .research_element_definition_characteristic import (
    ResearchElementDefinitionCharacteristic,
)
from .research_element_definition_characteristic_participant_effective_group_measure import (
    ResearchElementDefinitionCharacteristicParticipantEffectiveGroupMeasure,
)
from .research_element_definition_characteristic_study_effective_group_measure import (
    ResearchElementDefinitionCharacteristicStudyEffectiveGroupMeasure,
)
from .research_element_definition_status import ResearchElementDefinitionStatus
from .research_element_definition_type import ResearchElementDefinitionType
from .research_element_definition_variable_type import (
    ResearchElementDefinitionVariableType,
)
from .research_study import ResearchStudy
from .research_study_arm import ResearchStudyArm
from .research_study_objective import ResearchStudyObjective
from .research_study_status import ResearchStudyStatus
from .research_subject import ResearchSubject
from .research_subject_status import ResearchSubjectStatus
from .resource_list import ResourceList
from .risk_assessment import RiskAssessment
from .risk_assessment_prediction import RiskAssessmentPrediction
from .risk_evidence_synthesis import RiskEvidenceSynthesis
from .risk_evidence_synthesis_certainty import RiskEvidenceSynthesisCertainty
from .risk_evidence_synthesis_certainty_subcomponent import (
    RiskEvidenceSynthesisCertaintySubcomponent,
)
from .risk_evidence_synthesis_precision_estimate import (
    RiskEvidenceSynthesisPrecisionEstimate,
)
from .risk_evidence_synthesis_risk_estimate import RiskEvidenceSynthesisRiskEstimate
from .risk_evidence_synthesis_sample_size import RiskEvidenceSynthesisSampleSize
from .risk_evidence_synthesis_status import RiskEvidenceSynthesisStatus
from .sampled_data import SampledData
from .schedule import Schedule
from .search_parameter import SearchParameter
from .search_parameter_comparator_item import SearchParameterComparatorItem
from .search_parameter_component import SearchParameterComponent
from .search_parameter_modifier_item import SearchParameterModifierItem
from .search_parameter_status import SearchParameterStatus
from .search_parameter_type import SearchParameterType
from .search_parameter_xpath_usage import SearchParameterXpathUsage
from .service_request import ServiceRequest
from .signature import Signature
from .slot import Slot
from .slot_status import SlotStatus
from .smart_app_launch import SmartAppLaunch
from .specimen import Specimen
from .specimen_collection import SpecimenCollection
from .specimen_container import SpecimenContainer
from .specimen_definition import SpecimenDefinition
from .specimen_definition_additive import SpecimenDefinitionAdditive
from .specimen_definition_container import SpecimenDefinitionContainer
from .specimen_definition_handling import SpecimenDefinitionHandling
from .specimen_definition_type_tested import SpecimenDefinitionTypeTested
from .specimen_definition_type_tested_preference import (
    SpecimenDefinitionTypeTestedPreference,
)
from .specimen_processing import SpecimenProcessing
from .specimen_status import SpecimenStatus
from .string import String
from .structure_definition import StructureDefinition
from .structure_definition_context import StructureDefinitionContext
from .structure_definition_context_type import StructureDefinitionContextType
from .structure_definition_derivation import StructureDefinitionDerivation
from .structure_definition_differential import StructureDefinitionDifferential
from .structure_definition_fhir_version import StructureDefinitionFhirVersion
from .structure_definition_kind import StructureDefinitionKind
from .structure_definition_mapping import StructureDefinitionMapping
from .structure_definition_snapshot import StructureDefinitionSnapshot
from .structure_definition_status import StructureDefinitionStatus
from .structure_map import StructureMap
from .structure_map_dependent import StructureMapDependent
from .structure_map_group import StructureMapGroup
from .structure_map_group_type_mode import StructureMapGroupTypeMode
from .structure_map_input import StructureMapInput
from .structure_map_input_mode import StructureMapInputMode
from .structure_map_parameter import StructureMapParameter
from .structure_map_rule import StructureMapRule
from .structure_map_source import StructureMapSource
from .structure_map_source_list_mode import StructureMapSourceListMode
from .structure_map_status import StructureMapStatus
from .structure_map_structure import StructureMapStructure
from .structure_map_structure_mode import StructureMapStructureMode
from .structure_map_target import StructureMapTarget
from .structure_map_target_context_type import StructureMapTargetContextType
from .structure_map_target_list_mode_item import StructureMapTargetListModeItem
from .structure_map_target_transform import StructureMapTargetTransform
from .subscription import Subscription
from .subscription_channel import SubscriptionChannel
from .subscription_channel_type import SubscriptionChannelType
from .subscription_status import SubscriptionStatus
from .substance import Substance
from .substance_amount import SubstanceAmount
from .substance_amount_reference_range import SubstanceAmountReferenceRange
from .substance_ingredient import SubstanceIngredient
from .substance_instance import SubstanceInstance
from .substance_nucleic_acid import SubstanceNucleicAcid
from .substance_nucleic_acid_linkage import SubstanceNucleicAcidLinkage
from .substance_nucleic_acid_subunit import SubstanceNucleicAcidSubunit
from .substance_nucleic_acid_sugar import SubstanceNucleicAcidSugar
from .substance_polymer import SubstancePolymer
from .substance_polymer_degree_of_polymerisation import (
    SubstancePolymerDegreeOfPolymerisation,
)
from .substance_polymer_monomer_set import SubstancePolymerMonomerSet
from .substance_polymer_repeat import SubstancePolymerRepeat
from .substance_polymer_repeat_unit import SubstancePolymerRepeatUnit
from .substance_polymer_starting_material import SubstancePolymerStartingMaterial
from .substance_polymer_structural_representation import (
    SubstancePolymerStructuralRepresentation,
)
from .substance_protein import SubstanceProtein
from .substance_protein_subunit import SubstanceProteinSubunit
from .substance_reference_information import SubstanceReferenceInformation
from .substance_reference_information_classification import (
    SubstanceReferenceInformationClassification,
)
from .substance_reference_information_gene import SubstanceReferenceInformationGene
from .substance_reference_information_gene_element import (
    SubstanceReferenceInformationGeneElement,
)
from .substance_reference_information_target import SubstanceReferenceInformationTarget
from .substance_source_material import SubstanceSourceMaterial
from .substance_source_material_author import SubstanceSourceMaterialAuthor
from .substance_source_material_fraction_description import (
    SubstanceSourceMaterialFractionDescription,
)
from .substance_source_material_hybrid import SubstanceSourceMaterialHybrid
from .substance_source_material_organism import SubstanceSourceMaterialOrganism
from .substance_source_material_organism_general import (
    SubstanceSourceMaterialOrganismGeneral,
)
from .substance_source_material_part_description import (
    SubstanceSourceMaterialPartDescription,
)
from .substance_specification import SubstanceSpecification
from .substance_specification_code import SubstanceSpecificationCode
from .substance_specification_isotope import SubstanceSpecificationIsotope
from .substance_specification_moiety import SubstanceSpecificationMoiety
from .substance_specification_molecular_weight import (
    SubstanceSpecificationMolecularWeight,
)
from .substance_specification_name import SubstanceSpecificationName
from .substance_specification_official import SubstanceSpecificationOfficial
from .substance_specification_property import SubstanceSpecificationProperty
from .substance_specification_relationship import SubstanceSpecificationRelationship
from .substance_specification_representation import SubstanceSpecificationRepresentation
from .substance_specification_structure import SubstanceSpecificationStructure
from .substance_status import SubstanceStatus
from .supply_delivery import SupplyDelivery
from .supply_delivery_status import SupplyDeliveryStatus
from .supply_delivery_supplied_item import SupplyDeliverySuppliedItem
from .supply_request import SupplyRequest
from .supply_request_parameter import SupplyRequestParameter
from .supply_request_status import SupplyRequestStatus
from .task import Task
from .task_input import TaskInput
from .task_intent import TaskIntent
from .task_output import TaskOutput
from .task_restriction import TaskRestriction
from .task_status import TaskStatus
from .terminology_capabilities import TerminologyCapabilities
from .terminology_capabilities_closure import TerminologyCapabilitiesClosure
from .terminology_capabilities_code_search import TerminologyCapabilitiesCodeSearch
from .terminology_capabilities_code_system import TerminologyCapabilitiesCodeSystem
from .terminology_capabilities_expansion import TerminologyCapabilitiesExpansion
from .terminology_capabilities_filter import TerminologyCapabilitiesFilter
from .terminology_capabilities_implementation import (
    TerminologyCapabilitiesImplementation,
)
from .terminology_capabilities_parameter import TerminologyCapabilitiesParameter
from .terminology_capabilities_software import TerminologyCapabilitiesSoftware
from .terminology_capabilities_status import TerminologyCapabilitiesStatus
from .terminology_capabilities_translation import TerminologyCapabilitiesTranslation
from .terminology_capabilities_validate_code import TerminologyCapabilitiesValidateCode
from .terminology_capabilities_version import TerminologyCapabilitiesVersion
from .test_report import TestReport
from .test_report_action import TestReportAction
from .test_report_action_1 import TestReportAction1
from .test_report_action_2 import TestReportAction2
from .test_report_assert import TestReportAssert
from .test_report_assert_result import TestReportAssertResult
from .test_report_operation import TestReportOperation
from .test_report_operation_result import TestReportOperationResult
from .test_report_participant import TestReportParticipant
from .test_report_participant_type import TestReportParticipantType
from .test_report_result import TestReportResult
from .test_report_setup import TestReportSetup
from .test_report_status import TestReportStatus
from .test_report_teardown import TestReportTeardown
from .test_report_test import TestReportTest
from .test_script import TestScript
from .test_script_action import TestScriptAction
from .test_script_action_1 import TestScriptAction1
from .test_script_action_2 import TestScriptAction2
from .test_script_assert import TestScriptAssert
from .test_script_assert_direction import TestScriptAssertDirection
from .test_script_assert_operator import TestScriptAssertOperator
from .test_script_assert_request_method import TestScriptAssertRequestMethod
from .test_script_assert_response import TestScriptAssertResponse
from .test_script_capability import TestScriptCapability
from .test_script_destination import TestScriptDestination
from .test_script_fixture import TestScriptFixture
from .test_script_link import TestScriptLink
from .test_script_metadata import TestScriptMetadata
from .test_script_operation import TestScriptOperation
from .test_script_operation_method import TestScriptOperationMethod
from .test_script_origin import TestScriptOrigin
from .test_script_request_header import TestScriptRequestHeader
from .test_script_setup import TestScriptSetup
from .test_script_status import TestScriptStatus
from .test_script_teardown import TestScriptTeardown
from .test_script_test import TestScriptTest
from .test_script_variable import TestScriptVariable
from .time import Time
from .timing import Timing
from .timing_repeat import TimingRepeat
from .timing_repeat_duration_unit import TimingRepeatDurationUnit
from .timing_repeat_period_unit import TimingRepeatPeriodUnit
from .timing_repeat_when_item import TimingRepeatWhenItem
from .trigger_definition import TriggerDefinition
from .trigger_definition_type import TriggerDefinitionType
from .unsigned_int import UnsignedInt
from .uri import Uri
from .url import Url
from .usage_context import UsageContext
from .user import User
from .user_configuration import UserConfiguration
from .user_configuration_menu import UserConfigurationMenu
from .user_configuration_menu_link import UserConfigurationMenuLink
from .user_configuration_option import UserConfigurationOption
from .user_configuration_search import UserConfigurationSearch
from .uuid_ import Uuid
from .value_set import ValueSet
from .value_set_compose import ValueSetCompose
from .value_set_concept import ValueSetConcept
from .value_set_contains import ValueSetContains
from .value_set_designation import ValueSetDesignation
from .value_set_expansion import ValueSetExpansion
from .value_set_filter import ValueSetFilter
from .value_set_filter_op import ValueSetFilterOp
from .value_set_include import ValueSetInclude
from .value_set_parameter import ValueSetParameter
from .value_set_status import ValueSetStatus
from .verification_result import VerificationResult
from .verification_result_attestation import VerificationResultAttestation
from .verification_result_primary_source import VerificationResultPrimarySource
from .verification_result_validator import VerificationResultValidator
from .vision_prescription import VisionPrescription
from .vision_prescription_lens_specification import VisionPrescriptionLensSpecification
from .vision_prescription_lens_specification_eye import (
    VisionPrescriptionLensSpecificationEye,
)
from .vision_prescription_prism import VisionPrescriptionPrism
from .vision_prescription_prism_base import VisionPrescriptionPrismBase
from .xhtml import Xhtml

__all__ = [
    "AccessPolicy",
    "AccessPolicyIpAccessRule",
    "AccessPolicyIpAccessRuleAction",
    "AccessPolicyResource",
    "AccessPolicyResourceWriteCriteria",
    "Account",
    "AccountCoverage",
    "AccountGuarantor",
    "AccountStatus",
    "ActivityDefinition",
    "ActivityDefinitionDynamicValue",
    "ActivityDefinitionParticipant",
    "ActivityDefinitionStatus",
    "Address",
    "AddressType",
    "AddressUse",
    "AdverseEvent",
    "AdverseEventActuality",
    "AdverseEventCausality",
    "AdverseEventSuspectEntity",
    "Age",
    "AgeComparator",
    "Agent",
    "AgentChannel",
    "AgentSetting",
    "AgentStatus",
    "AllergyIntolerance",
    "AllergyIntoleranceCategoryItem",
    "AllergyIntoleranceCriticality",
    "AllergyIntoleranceReaction",
    "AllergyIntoleranceReactionSeverity",
    "AllergyIntoleranceType",
    "Annotation",
    "Appointment",
    "AppointmentParticipant",
    "AppointmentParticipantRequired",
    "AppointmentParticipantStatus",
    "AppointmentResponse",
    "AppointmentStatus",
    "AsyncJob",
    "AsyncJobStatus",
    "Attachment",
    "AuditEvent",
    "AuditEventAction",
    "AuditEventAgent",
    "AuditEventDetail",
    "AuditEventEntity",
    "AuditEventNetwork",
    "AuditEventNetworkType",
    "AuditEventOutcome",
    "AuditEventSource",
    "Base64Binary",
    "BaseResource",
    "Basic",
    "Binary",
    "BiologicallyDerivedProduct",
    "BiologicallyDerivedProductCollection",
    "BiologicallyDerivedProductManipulation",
    "BiologicallyDerivedProductProcessing",
    "BiologicallyDerivedProductProductCategory",
    "BiologicallyDerivedProductStatus",
    "BiologicallyDerivedProductStorage",
    "BiologicallyDerivedProductStorageScale",
    "BodyStructure",
    "Boolean",
    "Bot",
    "BotAuditEventDestinationItem",
    "BotAuditEventTrigger",
    "BotRuntimeVersion",
    "BulkDataExport",
    "BulkDataExportDeleted",
    "BulkDataExportError",
    "BulkDataExportOutput",
    "BulkDataExportStatus",
    "Bundle",
    "BundleEntry",
    "BundleLink",
    "BundleRequest",
    "BundleRequestMethod",
    "BundleResponse",
    "BundleSearch",
    "BundleSearchMode",
    "BundleType",
    "Canonical",
    "CapabilityStatement",
    "CapabilityStatementDocument",
    "CapabilityStatementDocumentMode",
    "CapabilityStatementEndpoint",
    "CapabilityStatementFhirVersion",
    "CapabilityStatementImplementation",
    "CapabilityStatementInteraction",
    "CapabilityStatementInteraction1",
    "CapabilityStatementInteraction1Code",
    "CapabilityStatementInteractionCode",
    "CapabilityStatementKind",
    "CapabilityStatementMessaging",
    "CapabilityStatementOperation",
    "CapabilityStatementResource",
    "CapabilityStatementResourceConditionalDelete",
    "CapabilityStatementResourceConditionalRead",
    "CapabilityStatementResourceReferencePolicyItem",
    "CapabilityStatementResourceVersioning",
    "CapabilityStatementRest",
    "CapabilityStatementRestMode",
    "CapabilityStatementSearchParam",
    "CapabilityStatementSearchParamType",
    "CapabilityStatementSecurity",
    "CapabilityStatementSoftware",
    "CapabilityStatementStatus",
    "CapabilityStatementSupportedMessage",
    "CapabilityStatementSupportedMessageMode",
    "CarePlan",
    "CarePlanActivity",
    "CarePlanDetail",
    "CarePlanDetailStatus",
    "CareTeam",
    "CareTeamParticipant",
    "CareTeamStatus",
    "CatalogEntry",
    "CatalogEntryRelatedEntry",
    "CatalogEntryRelatedEntryRelationtype",
    "CatalogEntryStatus",
    "ChargeItem",
    "ChargeItemDefinition",
    "ChargeItemDefinitionApplicability",
    "ChargeItemDefinitionPriceComponent",
    "ChargeItemDefinitionPropertyGroup",
    "ChargeItemDefinitionStatus",
    "ChargeItemPerformer",
    "ChargeItemStatus",
    "Claim",
    "ClaimAccident",
    "ClaimCareTeam",
    "ClaimDetail",
    "ClaimDiagnosis",
    "ClaimInsurance",
    "ClaimItem",
    "ClaimPayee",
    "ClaimProcedure",
    "ClaimRelated",
    "ClaimResponse",
    "ClaimResponseAddItem",
    "ClaimResponseAdjudication",
    "ClaimResponseDetail",
    "ClaimResponseDetail1",
    "ClaimResponseError",
    "ClaimResponseInsurance",
    "ClaimResponseItem",
    "ClaimResponsePayment",
    "ClaimResponseProcessNote",
    "ClaimResponseProcessNoteType",
    "ClaimResponseSubDetail",
    "ClaimResponseSubDetail1",
    "ClaimResponseTotal",
    "ClaimSubDetail",
    "ClaimSupportingInfo",
    "ClaimUse",
    "ClientApplication",
    "ClinicalImpression",
    "ClinicalImpressionFinding",
    "ClinicalImpressionInvestigation",
    "Code",
    "CodeSystem",
    "CodeSystemConcept",
    "CodeSystemContent",
    "CodeSystemDesignation",
    "CodeSystemFilter",
    "CodeSystemHierarchyMeaning",
    "CodeSystemProperty",
    "CodeSystemProperty1",
    "CodeSystemPropertyType",
    "CodeSystemStatus",
    "CodeableConcept",
    "Coding",
    "Communication",
    "CommunicationPayload",
    "CommunicationRequest",
    "CommunicationRequestPayload",
    "CompartmentDefinition",
    "CompartmentDefinitionCode",
    "CompartmentDefinitionResource",
    "CompartmentDefinitionStatus",
    "Composition",
    "CompositionAttester",
    "CompositionAttesterMode",
    "CompositionEvent",
    "CompositionRelatesTo",
    "CompositionSection",
    "CompositionStatus",
    "ConceptMap",
    "ConceptMapDependsOn",
    "ConceptMapElement",
    "ConceptMapGroup",
    "ConceptMapStatus",
    "ConceptMapTarget",
    "ConceptMapTargetEquivalence",
    "ConceptMapUnmapped",
    "ConceptMapUnmappedMode",
    "Condition",
    "ConditionEvidence",
    "ConditionStage",
    "Consent",
    "ConsentActor",
    "ConsentData",
    "ConsentDataMeaning",
    "ConsentPolicy",
    "ConsentProvision",
    "ConsentProvisionType",
    "ConsentStatus",
    "ConsentVerification",
    "ContactDetail",
    "ContactPoint",
    "ContactPointSystem",
    "ContactPointUse",
    "Contract",
    "ContractAction",
    "ContractAnswer",
    "ContractAsset",
    "ContractContentDefinition",
    "ContractContext",
    "ContractFriendly",
    "ContractLegal",
    "ContractOffer",
    "ContractParty",
    "ContractRule",
    "ContractSecurityLabel",
    "ContractSigner",
    "ContractSubject",
    "ContractTerm",
    "ContractValuedItem",
    "Contributor",
    "ContributorType",
    "Count",
    "CountComparator",
    "Coverage",
    "CoverageClass",
    "CoverageCostToBeneficiary",
    "CoverageEligibilityRequest",
    "CoverageEligibilityRequestDiagnosis",
    "CoverageEligibilityRequestInsurance",
    "CoverageEligibilityRequestItem",
    "CoverageEligibilityRequestPurposeItem",
    "CoverageEligibilityRequestSupportingInfo",
    "CoverageEligibilityResponse",
    "CoverageEligibilityResponseBenefit",
    "CoverageEligibilityResponseError",
    "CoverageEligibilityResponseInsurance",
    "CoverageEligibilityResponseItem",
    "CoverageEligibilityResponseOutcome",
    "CoverageEligibilityResponsePurposeItem",
    "CoverageException",
    "DataRequirement",
    "DataRequirementCodeFilter",
    "DataRequirementDateFilter",
    "DataRequirementSort",
    "DataRequirementSortDirection",
    "Date",
    "DateTime",
    "Decimal",
    "DetectedIssue",
    "DetectedIssueEvidence",
    "DetectedIssueMitigation",
    "DetectedIssueSeverity",
    "Device",
    "DeviceDefinition",
    "DeviceDefinitionCapability",
    "DeviceDefinitionClassification",
    "DeviceDefinitionDeviceName",
    "DeviceDefinitionDeviceNameType",
    "DeviceDefinitionMaterial",
    "DeviceDefinitionProperty",
    "DeviceDefinitionSpecialization",
    "DeviceDefinitionUdiDeviceIdentifier",
    "DeviceDeviceName",
    "DeviceDeviceNameType",
    "DeviceMetric",
    "DeviceMetricCalibration",
    "DeviceMetricCalibrationState",
    "DeviceMetricCalibrationType",
    "DeviceMetricCategory",
    "DeviceMetricColor",
    "DeviceMetricOperationalStatus",
    "DeviceProperty",
    "DeviceRequest",
    "DeviceRequestParameter",
    "DeviceSpecialization",
    "DeviceStatus",
    "DeviceUdiCarrier",
    "DeviceUdiCarrierEntryType",
    "DeviceUseStatement",
    "DeviceUseStatementStatus",
    "DeviceVersion",
    "DiagnosticReport",
    "DiagnosticReportMedia",
    "DiagnosticReportStatus",
    "Distance",
    "DistanceComparator",
    "DocumentManifest",
    "DocumentManifestRelated",
    "DocumentManifestStatus",
    "DocumentReference",
    "DocumentReferenceContent",
    "DocumentReferenceContext",
    "DocumentReferenceRelatesTo",
    "DocumentReferenceRelatesToCode",
    "DocumentReferenceStatus",
    "DomainConfiguration",
    "Dosage",
    "DosageDoseAndRate",
    "Duration",
    "DurationComparator",
    "EffectEvidenceSynthesis",
    "EffectEvidenceSynthesisCertainty",
    "EffectEvidenceSynthesisCertaintySubcomponent",
    "EffectEvidenceSynthesisEffectEstimate",
    "EffectEvidenceSynthesisPrecisionEstimate",
    "EffectEvidenceSynthesisResultsByExposure",
    "EffectEvidenceSynthesisResultsByExposureExposureState",
    "EffectEvidenceSynthesisSampleSize",
    "EffectEvidenceSynthesisStatus",
    "Element",
    "ElementDefinition",
    "ElementDefinitionBase",
    "ElementDefinitionBinding",
    "ElementDefinitionBindingStrength",
    "ElementDefinitionConstraint",
    "ElementDefinitionConstraintSeverity",
    "ElementDefinitionDiscriminator",
    "ElementDefinitionDiscriminatorType",
    "ElementDefinitionExample",
    "ElementDefinitionMapping",
    "ElementDefinitionRepresentationItem",
    "ElementDefinitionSlicing",
    "ElementDefinitionSlicingRules",
    "ElementDefinitionType",
    "ElementDefinitionTypeAggregationItem",
    "ElementDefinitionTypeVersioning",
    "Encounter",
    "EncounterClassHistory",
    "EncounterDiagnosis",
    "EncounterHospitalization",
    "EncounterLocation",
    "EncounterLocationStatus",
    "EncounterParticipant",
    "EncounterStatus",
    "EncounterStatusHistory",
    "EncounterStatusHistoryStatus",
    "Endpoint",
    "EndpointStatus",
    "EnrollmentRequest",
    "EnrollmentResponse",
    "EnrollmentResponseOutcome",
    "EpisodeOfCare",
    "EpisodeOfCareDiagnosis",
    "EpisodeOfCareStatus",
    "EpisodeOfCareStatusHistory",
    "EpisodeOfCareStatusHistoryStatus",
    "EventDefinition",
    "EventDefinitionStatus",
    "Evidence",
    "EvidenceStatus",
    "EvidenceVariable",
    "EvidenceVariableCharacteristic",
    "EvidenceVariableCharacteristicGroupMeasure",
    "EvidenceVariableStatus",
    "EvidenceVariableType",
    "ExampleScenario",
    "ExampleScenarioActor",
    "ExampleScenarioActorType",
    "ExampleScenarioAlternative",
    "ExampleScenarioContainedInstance",
    "ExampleScenarioInstance",
    "ExampleScenarioOperation",
    "ExampleScenarioProcess",
    "ExampleScenarioStatus",
    "ExampleScenarioStep",
    "ExampleScenarioVersion",
    "ExplanationOfBenefit",
    "ExplanationOfBenefitAccident",
    "ExplanationOfBenefitAddItem",
    "ExplanationOfBenefitAdjudication",
    "ExplanationOfBenefitBenefitBalance",
    "ExplanationOfBenefitCareTeam",
    "ExplanationOfBenefitDetail",
    "ExplanationOfBenefitDetail1",
    "ExplanationOfBenefitDiagnosis",
    "ExplanationOfBenefitFinancial",
    "ExplanationOfBenefitInsurance",
    "ExplanationOfBenefitItem",
    "ExplanationOfBenefitPayee",
    "ExplanationOfBenefitPayment",
    "ExplanationOfBenefitProcedure",
    "ExplanationOfBenefitProcessNote",
    "ExplanationOfBenefitProcessNoteType",
    "ExplanationOfBenefitRelated",
    "ExplanationOfBenefitStatus",
    "ExplanationOfBenefitSubDetail",
    "ExplanationOfBenefitSubDetail1",
    "ExplanationOfBenefitSupportingInfo",
    "ExplanationOfBenefitTotal",
    "Expression",
    "ExpressionLanguage",
    "Extension",
    "FamilyMemberHistory",
    "FamilyMemberHistoryCondition",
    "FamilyMemberHistoryStatus",
    "Flag",
    "FlagStatus",
    "Goal",
    "GoalLifecycleStatus",
    "GoalTarget",
    "GraphDefinition",
    "GraphDefinitionCompartment",
    "GraphDefinitionCompartmentRule",
    "GraphDefinitionCompartmentUse",
    "GraphDefinitionLink",
    "GraphDefinitionStatus",
    "GraphDefinitionTarget",
    "Group",
    "GroupCharacteristic",
    "GroupMember",
    "GroupType",
    "GuidanceResponse",
    "GuidanceResponseStatus",
    "HealthcareService",
    "HealthcareServiceAvailableTime",
    "HealthcareServiceAvailableTimeDaysOfWeekItem",
    "HealthcareServiceEligibility",
    "HealthcareServiceNotAvailable",
    "HumanName",
    "HumanNameUse",
    "Id",
    "Identifier",
    "IdentifierUse",
    "IdentityProvider",
    "ImagingStudy",
    "ImagingStudyInstance",
    "ImagingStudyPerformer",
    "ImagingStudySeries",
    "ImagingStudyStatus",
    "Immunization",
    "ImmunizationEducation",
    "ImmunizationEvaluation",
    "ImmunizationPerformer",
    "ImmunizationProtocolApplied",
    "ImmunizationReaction",
    "ImmunizationRecommendation",
    "ImmunizationRecommendationDateCriterion",
    "ImmunizationRecommendationRecommendation",
    "ImplementationGuide",
    "ImplementationGuideDefinition",
    "ImplementationGuideDependsOn",
    "ImplementationGuideFhirVersionItem",
    "ImplementationGuideGlobal",
    "ImplementationGuideGrouping",
    "ImplementationGuideLicense",
    "ImplementationGuideManifest",
    "ImplementationGuidePage",
    "ImplementationGuidePage1",
    "ImplementationGuidePageGeneration",
    "ImplementationGuideParameter",
    "ImplementationGuideParameterCode",
    "ImplementationGuideResource",
    "ImplementationGuideResource1",
    "ImplementationGuideResourceFhirVersionItem",
    "ImplementationGuideStatus",
    "ImplementationGuideTemplate",
    "Instant",
    "InsurancePlan",
    "InsurancePlanBenefit",
    "InsurancePlanBenefit1",
    "InsurancePlanContact",
    "InsurancePlanCost",
    "InsurancePlanCoverage",
    "InsurancePlanGeneralCost",
    "InsurancePlanLimit",
    "InsurancePlanPlan",
    "InsurancePlanSpecificCost",
    "InsurancePlanStatus",
    "Integer",
    "Invoice",
    "InvoiceLineItem",
    "InvoiceParticipant",
    "InvoicePriceComponent",
    "InvoicePriceComponentType",
    "InvoiceStatus",
    "JsonWebKey",
    "Library",
    "LibraryStatus",
    "Linkage",
    "LinkageItem",
    "LinkageItemType",
    "List",
    "ListEntry",
    "ListMode",
    "ListStatus",
    "Location",
    "LocationHoursOfOperation",
    "LocationMode",
    "LocationPosition",
    "LocationStatus",
    "Login",
    "LoginAuthMethod",
    "LoginCodeChallengeMethod",
    "Markdown",
    "MarketingStatus",
    "Measure",
    "MeasureComponent",
    "MeasureGroup",
    "MeasurePopulation",
    "MeasureReport",
    "MeasureReportComponent",
    "MeasureReportGroup",
    "MeasureReportPopulation",
    "MeasureReportPopulation1",
    "MeasureReportStatus",
    "MeasureReportStratifier",
    "MeasureReportStratum",
    "MeasureReportType",
    "MeasureStatus",
    "MeasureStratifier",
    "MeasureSupplementalData",
    "Media",
    "Medication",
    "MedicationAdministration",
    "MedicationAdministrationDosage",
    "MedicationAdministrationPerformer",
    "MedicationBatch",
    "MedicationDispense",
    "MedicationDispensePerformer",
    "MedicationDispenseSubstitution",
    "MedicationIngredient",
    "MedicationKnowledge",
    "MedicationKnowledgeAdministrationGuidelines",
    "MedicationKnowledgeCost",
    "MedicationKnowledgeDosage",
    "MedicationKnowledgeDrugCharacteristic",
    "MedicationKnowledgeIngredient",
    "MedicationKnowledgeKinetics",
    "MedicationKnowledgeMaxDispense",
    "MedicationKnowledgeMedicineClassification",
    "MedicationKnowledgeMonitoringProgram",
    "MedicationKnowledgeMonograph",
    "MedicationKnowledgePackaging",
    "MedicationKnowledgePatientCharacteristics",
    "MedicationKnowledgeRegulatory",
    "MedicationKnowledgeRelatedMedicationKnowledge",
    "MedicationKnowledgeSchedule",
    "MedicationKnowledgeSubstitution",
    "MedicationRequest",
    "MedicationRequestDispenseRequest",
    "MedicationRequestInitialFill",
    "MedicationRequestSubstitution",
    "MedicationStatement",
    "MedicinalProduct",
    "MedicinalProductAuthorization",
    "MedicinalProductAuthorizationJurisdictionalAuthorization",
    "MedicinalProductAuthorizationProcedure",
    "MedicinalProductContraindication",
    "MedicinalProductContraindicationOtherTherapy",
    "MedicinalProductCountryLanguage",
    "MedicinalProductIndication",
    "MedicinalProductIndicationOtherTherapy",
    "MedicinalProductIngredient",
    "MedicinalProductIngredientReferenceStrength",
    "MedicinalProductIngredientSpecifiedSubstance",
    "MedicinalProductIngredientStrength",
    "MedicinalProductIngredientSubstance",
    "MedicinalProductInteraction",
    "MedicinalProductInteractionInteractant",
    "MedicinalProductManufactured",
    "MedicinalProductManufacturingBusinessOperation",
    "MedicinalProductName",
    "MedicinalProductNamePart",
    "MedicinalProductPackaged",
    "MedicinalProductPackagedBatchIdentifier",
    "MedicinalProductPackagedPackageItem",
    "MedicinalProductPharmaceutical",
    "MedicinalProductPharmaceuticalCharacteristics",
    "MedicinalProductPharmaceuticalRouteOfAdministration",
    "MedicinalProductPharmaceuticalTargetSpecies",
    "MedicinalProductPharmaceuticalWithdrawalPeriod",
    "MedicinalProductSpecialDesignation",
    "MedicinalProductUndesirableEffect",
    "MessageDefinition",
    "MessageDefinitionAllowedResponse",
    "MessageDefinitionCategory",
    "MessageDefinitionFocus",
    "MessageDefinitionResponseRequired",
    "MessageDefinitionStatus",
    "MessageHeader",
    "MessageHeaderDestination",
    "MessageHeaderResponse",
    "MessageHeaderResponseCode",
    "MessageHeaderSource",
    "Meta",
    "MolecularSequence",
    "MolecularSequenceInner",
    "MolecularSequenceOuter",
    "MolecularSequenceQuality",
    "MolecularSequenceQualityType",
    "MolecularSequenceReferenceSeq",
    "MolecularSequenceReferenceSeqOrientation",
    "MolecularSequenceReferenceSeqStrand",
    "MolecularSequenceRepository",
    "MolecularSequenceRepositoryType",
    "MolecularSequenceRoc",
    "MolecularSequenceStructureVariant",
    "MolecularSequenceType",
    "MolecularSequenceVariant",
    "Money",
    "NamingSystem",
    "NamingSystemKind",
    "NamingSystemStatus",
    "NamingSystemUniqueId",
    "NamingSystemUniqueIdType",
    "Narrative",
    "NarrativeStatus",
    "NutritionOrder",
    "NutritionOrderAdministration",
    "NutritionOrderEnteralFormula",
    "NutritionOrderNutrient",
    "NutritionOrderOralDiet",
    "NutritionOrderSupplement",
    "NutritionOrderTexture",
    "Observation",
    "ObservationComponent",
    "ObservationDefinition",
    "ObservationDefinitionPermittedDataTypeItem",
    "ObservationDefinitionQualifiedInterval",
    "ObservationDefinitionQualifiedIntervalCategory",
    "ObservationDefinitionQualifiedIntervalGender",
    "ObservationDefinitionQuantitativeDetails",
    "ObservationReferenceRange",
    "ObservationStatus",
    "Oid",
    "OperationDefinition",
    "OperationDefinitionBinding",
    "OperationDefinitionBindingStrength",
    "OperationDefinitionKind",
    "OperationDefinitionOverload",
    "OperationDefinitionParameter",
    "OperationDefinitionParameterSearchType",
    "OperationDefinitionParameterUse",
    "OperationDefinitionReferencedFrom",
    "OperationDefinitionStatus",
    "OperationOutcome",
    "OperationOutcomeIssue",
    "OperationOutcomeIssueCode",
    "OperationOutcomeIssueSeverity",
    "Organization",
    "OrganizationAffiliation",
    "OrganizationContact",
    "ParameterDefinition",
    "Parameters",
    "ParametersParameter",
    "PasswordChangeRequest",
    "PasswordChangeRequestType",
    "Patient",
    "PatientCommunication",
    "PatientContact",
    "PatientContactGender",
    "PatientGender",
    "PatientLink",
    "PatientLinkType",
    "PaymentNotice",
    "PaymentReconciliation",
    "PaymentReconciliationDetail",
    "PaymentReconciliationOutcome",
    "PaymentReconciliationProcessNote",
    "PaymentReconciliationProcessNoteType",
    "Period",
    "Person",
    "PersonGender",
    "PersonLink",
    "PersonLinkAssurance",
    "PlanDefinition",
    "PlanDefinitionAction",
    "PlanDefinitionActionCardinalityBehavior",
    "PlanDefinitionActionGroupingBehavior",
    "PlanDefinitionActionPrecheckBehavior",
    "PlanDefinitionActionRequiredBehavior",
    "PlanDefinitionActionSelectionBehavior",
    "PlanDefinitionCondition",
    "PlanDefinitionConditionKind",
    "PlanDefinitionDynamicValue",
    "PlanDefinitionGoal",
    "PlanDefinitionParticipant",
    "PlanDefinitionParticipantType",
    "PlanDefinitionRelatedAction",
    "PlanDefinitionRelatedActionRelationship",
    "PlanDefinitionStatus",
    "PlanDefinitionTarget",
    "Population",
    "PositiveInt",
    "Practitioner",
    "PractitionerGender",
    "PractitionerQualification",
    "PractitionerRole",
    "PractitionerRoleAvailableTime",
    "PractitionerRoleNotAvailable",
    "Procedure",
    "ProcedureFocalDevice",
    "ProcedurePerformer",
    "ProdCharacteristic",
    "ProductShelfLife",
    "Project",
    "ProjectFeaturesItem",
    "ProjectMembership",
    "ProjectMembershipAccess",
    "ProjectMembershipAccessParameter",
    "ProjectSecret",
    "ProjectSite",
    "Provenance",
    "ProvenanceAgent",
    "ProvenanceEntity",
    "ProvenanceEntityRole",
    "Quantity",
    "QuantityComparator",
    "Questionnaire",
    "QuestionnaireAnswerOption",
    "QuestionnaireEnableWhen",
    "QuestionnaireEnableWhenOperator",
    "QuestionnaireInitial",
    "QuestionnaireItem",
    "QuestionnaireItemEnableBehavior",
    "QuestionnaireItemType",
    "QuestionnaireResponse",
    "QuestionnaireResponseAnswer",
    "QuestionnaireResponseItem",
    "QuestionnaireResponseStatus",
    "QuestionnaireStatus",
    "Range",
    "Ratio",
    "Reference",
    "RelatedArtifact",
    "RelatedArtifactType",
    "RelatedPerson",
    "RelatedPersonCommunication",
    "RelatedPersonGender",
    "RequestGroup",
    "RequestGroupAction",
    "RequestGroupCondition",
    "RequestGroupRelatedAction",
    "ResearchDefinition",
    "ResearchDefinitionStatus",
    "ResearchElementDefinition",
    "ResearchElementDefinitionCharacteristic",
    "ResearchElementDefinitionCharacteristicParticipantEffectiveGroupMeasure",
    "ResearchElementDefinitionCharacteristicStudyEffectiveGroupMeasure",
    "ResearchElementDefinitionStatus",
    "ResearchElementDefinitionType",
    "ResearchElementDefinitionVariableType",
    "ResearchStudy",
    "ResearchStudyArm",
    "ResearchStudyObjective",
    "ResearchStudyStatus",
    "ResearchSubject",
    "ResearchSubjectStatus",
    "ResourceList",
    "RiskAssessment",
    "RiskAssessmentPrediction",
    "RiskEvidenceSynthesis",
    "RiskEvidenceSynthesisCertainty",
    "RiskEvidenceSynthesisCertaintySubcomponent",
    "RiskEvidenceSynthesisPrecisionEstimate",
    "RiskEvidenceSynthesisRiskEstimate",
    "RiskEvidenceSynthesisSampleSize",
    "RiskEvidenceSynthesisStatus",
    "SampledData",
    "Schedule",
    "SearchParameter",
    "SearchParameterComparatorItem",
    "SearchParameterComponent",
    "SearchParameterModifierItem",
    "SearchParameterStatus",
    "SearchParameterType",
    "SearchParameterXpathUsage",
    "ServiceRequest",
    "Signature",
    "Slot",
    "SlotStatus",
    "SmartAppLaunch",
    "Specimen",
    "SpecimenCollection",
    "SpecimenContainer",
    "SpecimenDefinition",
    "SpecimenDefinitionAdditive",
    "SpecimenDefinitionContainer",
    "SpecimenDefinitionHandling",
    "SpecimenDefinitionTypeTested",
    "SpecimenDefinitionTypeTestedPreference",
    "SpecimenProcessing",
    "SpecimenStatus",
    "String",
    "StructureDefinition",
    "StructureDefinitionContext",
    "StructureDefinitionContextType",
    "StructureDefinitionDerivation",
    "StructureDefinitionDifferential",
    "StructureDefinitionFhirVersion",
    "StructureDefinitionKind",
    "StructureDefinitionMapping",
    "StructureDefinitionSnapshot",
    "StructureDefinitionStatus",
    "StructureMap",
    "StructureMapDependent",
    "StructureMapGroup",
    "StructureMapGroupTypeMode",
    "StructureMapInput",
    "StructureMapInputMode",
    "StructureMapParameter",
    "StructureMapRule",
    "StructureMapSource",
    "StructureMapSourceListMode",
    "StructureMapStatus",
    "StructureMapStructure",
    "StructureMapStructureMode",
    "StructureMapTarget",
    "StructureMapTargetContextType",
    "StructureMapTargetListModeItem",
    "StructureMapTargetTransform",
    "Subscription",
    "SubscriptionChannel",
    "SubscriptionChannelType",
    "SubscriptionStatus",
    "Substance",
    "SubstanceAmount",
    "SubstanceAmountReferenceRange",
    "SubstanceIngredient",
    "SubstanceInstance",
    "SubstanceNucleicAcid",
    "SubstanceNucleicAcidLinkage",
    "SubstanceNucleicAcidSubunit",
    "SubstanceNucleicAcidSugar",
    "SubstancePolymer",
    "SubstancePolymerDegreeOfPolymerisation",
    "SubstancePolymerMonomerSet",
    "SubstancePolymerRepeat",
    "SubstancePolymerRepeatUnit",
    "SubstancePolymerStartingMaterial",
    "SubstancePolymerStructuralRepresentation",
    "SubstanceProtein",
    "SubstanceProteinSubunit",
    "SubstanceReferenceInformation",
    "SubstanceReferenceInformationClassification",
    "SubstanceReferenceInformationGene",
    "SubstanceReferenceInformationGeneElement",
    "SubstanceReferenceInformationTarget",
    "SubstanceSourceMaterial",
    "SubstanceSourceMaterialAuthor",
    "SubstanceSourceMaterialFractionDescription",
    "SubstanceSourceMaterialHybrid",
    "SubstanceSourceMaterialOrganism",
    "SubstanceSourceMaterialOrganismGeneral",
    "SubstanceSourceMaterialPartDescription",
    "SubstanceSpecification",
    "SubstanceSpecificationCode",
    "SubstanceSpecificationIsotope",
    "SubstanceSpecificationMoiety",
    "SubstanceSpecificationMolecularWeight",
    "SubstanceSpecificationName",
    "SubstanceSpecificationOfficial",
    "SubstanceSpecificationProperty",
    "SubstanceSpecificationRelationship",
    "SubstanceSpecificationRepresentation",
    "SubstanceSpecificationStructure",
    "SubstanceStatus",
    "SupplyDelivery",
    "SupplyDeliveryStatus",
    "SupplyDeliverySuppliedItem",
    "SupplyRequest",
    "SupplyRequestParameter",
    "SupplyRequestStatus",
    "Task",
    "TaskInput",
    "TaskIntent",
    "TaskOutput",
    "TaskRestriction",
    "TaskStatus",
    "TerminologyCapabilities",
    "TerminologyCapabilitiesClosure",
    "TerminologyCapabilitiesCodeSearch",
    "TerminologyCapabilitiesCodeSystem",
    "TerminologyCapabilitiesExpansion",
    "TerminologyCapabilitiesFilter",
    "TerminologyCapabilitiesImplementation",
    "TerminologyCapabilitiesParameter",
    "TerminologyCapabilitiesSoftware",
    "TerminologyCapabilitiesStatus",
    "TerminologyCapabilitiesTranslation",
    "TerminologyCapabilitiesValidateCode",
    "TerminologyCapabilitiesVersion",
    "TestReport",
    "TestReportAction",
    "TestReportAction1",
    "TestReportAction2",
    "TestReportAssert",
    "TestReportAssertResult",
    "TestReportOperation",
    "TestReportOperationResult",
    "TestReportParticipant",
    "TestReportParticipantType",
    "TestReportResult",
    "TestReportSetup",
    "TestReportStatus",
    "TestReportTeardown",
    "TestReportTest",
    "TestScript",
    "TestScriptAction",
    "TestScriptAction1",
    "TestScriptAction2",
    "TestScriptAssert",
    "TestScriptAssertDirection",
    "TestScriptAssertOperator",
    "TestScriptAssertRequestMethod",
    "TestScriptAssertResponse",
    "TestScriptCapability",
    "TestScriptDestination",
    "TestScriptFixture",
    "TestScriptLink",
    "TestScriptMetadata",
    "TestScriptOperation",
    "TestScriptOperationMethod",
    "TestScriptOrigin",
    "TestScriptRequestHeader",
    "TestScriptSetup",
    "TestScriptStatus",
    "TestScriptTeardown",
    "TestScriptTest",
    "TestScriptVariable",
    "Time",
    "Timing",
    "TimingRepeat",
    "TimingRepeatDurationUnit",
    "TimingRepeatPeriodUnit",
    "TimingRepeatWhenItem",
    "TriggerDefinition",
    "TriggerDefinitionType",
    "UnsignedInt",
    "Uri",
    "Url",
    "UsageContext",
    "User",
    "UserConfiguration",
    "UserConfigurationMenu",
    "UserConfigurationMenuLink",
    "UserConfigurationOption",
    "UserConfigurationSearch",
    "Uuid",
    "ValueSet",
    "ValueSetCompose",
    "ValueSetConcept",
    "ValueSetContains",
    "ValueSetDesignation",
    "ValueSetExpansion",
    "ValueSetFilter",
    "ValueSetFilterOp",
    "ValueSetInclude",
    "ValueSetParameter",
    "ValueSetStatus",
    "VerificationResult",
    "VerificationResultAttestation",
    "VerificationResultPrimarySource",
    "VerificationResultValidator",
    "VisionPrescription",
    "VisionPrescriptionLensSpecification",
    "VisionPrescriptionLensSpecificationEye",
    "VisionPrescriptionPrism",
    "VisionPrescriptionPrismBase",
    "Xhtml",
]
