# This file was auto-generated by Fern from our API Definition.

from ...core.pydantic_utilities import UniversalBaseModel
import typing_extensions
from ...core.serialization import FieldMetadata
import pydantic
import typing
from .us_state import UsState
from ...core.pydantic_utilities import IS_PYDANTIC_V2


class Address(UniversalBaseModel):
    """
    Examples
    --------
    from metriport.commons import Address

    Address(
        address_line_1="2261 Market Street",
        address_line_2="#4818",
        city="San Francisco",
        state="CA",
        zip="94114",
        country="USA",
    )
    """

    address_line_1: typing_extensions.Annotated[
        str, FieldMetadata(alias="addressLine1")
    ] = pydantic.Field()
    """
    The address.
    """

    address_line_2: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="addressLine2")
    ] = pydantic.Field(default=None)
    """
    The address details, for example `#4451`
    """

    city: str = pydantic.Field()
    """
    The city.
    """

    state: UsState = pydantic.Field()
    """
    The 2 letter state acronym, for example `CA`
    """

    zip: str = pydantic.Field()
    """
    Zip must be a string consisting of 5 numbers.
    """

    country: typing.Optional[str] = pydantic.Field(default=None)
    """
    Defaults to “USA”
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(
            extra="allow", frozen=True
        )  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
