/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.udf;

import com.alibaba.alink.executor.python.PythonUdfFactory;
import com.alibaba.alink.executor.util.JsonUtil;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.api.java.BatchTableEnvironment;
import org.apache.flink.table.api.java.StreamTableEnvironment;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdfManager {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    List<UdfConfigT> udfList = new ArrayList<UdfConfigT>();

    public UdfManager(JsonArray resources, JsonArray udfList) {
        JsonObject x;
        if (udfList == null) {
            return;
        }
        HashMap<Long, JsonObject> resHash = new HashMap<Long, JsonObject>();
        if (resources != null) {
            for (JsonElement e : resources) {
                x = e.getAsJsonObject();
                Long id = x.get("id").getAsLong();
                resHash.put(id, x);
            }
        }
        for (JsonElement e : udfList) {
            Long resId;
            x = e.getAsJsonObject();
            UdfConfigT config = new UdfConfigT();
            config.name = x.get("name").getAsString();
            if (x.has("className")) {
                config.className = x.get("className").getAsString();
            } else if (x.has("classObject")) {
                config.classObject = x.get("classObject").getAsString();
                config.classObjectType = x.get("classObjectType").getAsString();
            } else {
                throw new RuntimeException("Missing classInfo in udf:" + config.name);
            }
            config.language = x.get("language").getAsString();
            config.resultType = x.get("resultType").getAsString();
            config.type = x.has("udfType") ? x.get("udfType").getAsString() : x.get("type").getAsString();
            config.paths = new String[0];
            if (x.has("resourceId") && resHash.containsKey(resId = Long.valueOf(x.get("resourceId").getAsLong()))) {
                config.paths = new String[]{((JsonObject)resHash.get(resId)).get("name").getAsString()};
            }
            this.udfList.add(config);
        }
    }

    public void register(TableEnvironment env) {
        for (UdfConfigT c : this.udfList) {
            if (c.language.equalsIgnoreCase("python")) {
                this.registerPythonUdf(env, c);
                continue;
            }
            throw new RuntimeException("Unsupport language: " + c.language);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void registerPythonUdf(TableEnvironment env, UdfConfigT c) {
        if (c.type.equalsIgnoreCase("udf") || c.type.equalsIgnoreCase("ScalarFunction")) {
            ScalarFunction f = PythonUdfFactory.makeScalarFunction(c.name, c.resultType, c.toUdfJson());
            env.registerFunction(c.name, f);
            return;
        } else {
            if (!c.type.equalsIgnoreCase("udtf") && !c.type.equalsIgnoreCase("TableFunction")) throw new RuntimeException("not implement yet");
            TableFunction<Row> f = PythonUdfFactory.makeTableFunction(c.name, c.toUdfJson());
            if (env instanceof StreamTableEnvironment) {
                ((StreamTableEnvironment)env).registerFunction(c.name, f);
                return;
            } else {
                if (!(env instanceof BatchTableEnvironment)) throw new RuntimeException("env is not support.");
                ((BatchTableEnvironment)env).registerFunction(c.name, f);
            }
        }
    }

    public static class UdfConfigT
    implements Serializable {
        public String name;
        public String language;
        public String[] paths;
        public String className;
        public String classObject;
        public String classObjectType;
        public String resultType;
        public String type;

        public String toUdfJson() {
            JsonObject m = new JsonObject();
            m.addProperty("language", this.language);
            m.add("paths", JsonUtil.gson.toJsonTree((Object)this.paths));
            if (this.className != null) {
                m.addProperty("className", this.className);
            } else {
                m.addProperty("classObject", this.classObject);
                m.addProperty("classObjectType", this.classObjectType);
            }
            m.addProperty("resultType", this.resultType);
            return m.toString();
        }
    }
}

