/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.python.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TarFileUtil {
    private static Logger LOG = LoggerFactory.getLogger(TarFileUtil.class);

    private static void safeMakeDir(File dir) throws IOException {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create directory: " + dir.toString());
        }
    }

    public static void unTar(File inFile, File untarDir) throws IOException {
        TarFileUtil.safeMakeDir(untarDir);
        boolean gzipped = inFile.toString().endsWith("gz");
        TarFileUtil.unTarUsingJava(inFile, untarDir, gzipped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unTarUsingJava(File inFile, File untarDir, boolean gzipped) throws IOException {
        String base = untarDir.getCanonicalPath();
        try (InputStream inputStream = null;){
            inputStream = gzipped ? new BufferedInputStream(new GZIPInputStream(new FileInputStream(inFile))) : new BufferedInputStream(new FileInputStream(inFile));
            try (TarArchiveInputStream tis = new TarArchiveInputStream(inputStream);){
                TarArchiveEntry entry = tis.getNextTarEntry();
                while (entry != null) {
                    TarFileUtil.unpackEntries(tis, entry, untarDir, base);
                    entry = tis.getNextTarEntry();
                }
            }
        }
    }

    private static void unpackEntries(TarArchiveInputStream tis, TarArchiveEntry entry, File outputDir, String base) throws IOException {
        File target = new File(outputDir, entry.getName());
        String found = target.getCanonicalPath();
        if (!found.startsWith(base)) {
            LOG.error("Invalid location {} is outside of {}", (Object)found, (Object)base);
            return;
        }
        if (entry.isDirectory()) {
            TarFileUtil.safeMakeDir(target);
            for (TarArchiveEntry e : entry.getDirectoryEntries()) {
                TarFileUtil.unpackEntries(tis, e, target, base);
            }
        } else if (entry.isSymbolicLink()) {
            Path src = target.toPath();
            Path dest = Paths.get(entry.getLinkName(), new String[0]);
            LOG.trace("Extracting sym link {} to {}", (Object)target, (Object)dest);
            Files.createSymbolicLink(src, dest, new FileAttribute[0]);
        } else if (entry.isFile()) {
            TarFileUtil.safeMakeDir(target.getParentFile());
            TarFileUtil.writeToFile(tis, target);
        } else {
            LOG.error("{} is not a currently supported tar entry type.", (Object)entry);
        }
        Path p = target.toPath();
        if (Files.exists(p, new LinkOption[0])) {
            try {
                int mode = entry.getMode();
                Files.setPosixFilePermissions(p, TarFileUtil.parsePerms(mode));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    private static void writeToFile(InputStream in, File outFile) {
        try (FileOutputStream fos = new FileOutputStream(outFile);){
            int n;
            byte[] buf = new byte[65536];
            while ((n = in.read(buf)) >= 0) {
                if (n <= 0) continue;
                fos.write(buf, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Set<PosixFilePermission> parsePerms(int mode) {
        HashSet<PosixFilePermission> ret = new HashSet<PosixFilePermission>();
        if ((mode & 1) > 0) {
            ret.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((mode & 2) > 0) {
            ret.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((mode & 4) > 0) {
            ret.add(PosixFilePermission.OTHERS_READ);
        }
        if ((mode & 8) > 0) {
            ret.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((mode & 0x10) > 0) {
            ret.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((mode & 0x20) > 0) {
            ret.add(PosixFilePermission.GROUP_READ);
        }
        if ((mode & 0x40) > 0) {
            ret.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((mode & 0x80) > 0) {
            ret.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((mode & 0x100) > 0) {
            ret.add(PosixFilePermission.OWNER_READ);
        }
        return ret;
    }
}

