/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.python;

import com.alibaba.alink.executor.python.impl.PyBigDecimalScalarFunction;
import com.alibaba.alink.executor.python.impl.PyByteScalarFunction;
import com.alibaba.alink.executor.python.impl.PyFloatScalarFunction;
import com.alibaba.alink.executor.python.impl.PyIntegerScalarFunction;
import com.alibaba.alink.executor.python.impl.PyNewBooleanScalarFunction;
import com.alibaba.alink.executor.python.impl.PyNewDoubleScalarFunction;
import com.alibaba.alink.executor.python.impl.PyNewLongScalarFunction;
import com.alibaba.alink.executor.python.impl.PyNewStringScalarFunction;
import com.alibaba.alink.executor.python.impl.PyShortScalarFunction;
import com.alibaba.alink.executor.python.impl.PyTableFunction;
import com.alibaba.alink.executor.python.impl.PyTimestampScalarFunction;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.types.Row;

public class PythonUdfFactory {
    public static ScalarFunction makeScalarFunction(String fname, String resultType, String configJson) {
        switch (resultType.toUpperCase()) {
            case "BOOL": 
            case "BOOLEAN": {
                return new PyNewBooleanScalarFunction(fname, configJson);
            }
            case "BYTE": 
            case "TINYINT": {
                return new PyByteScalarFunction(fname, configJson);
            }
            case "SHORT": 
            case "SMALLINT": {
                return new PyShortScalarFunction(fname, configJson);
            }
            case "INT": 
            case "INTEGER": {
                return new PyIntegerScalarFunction(fname, configJson);
            }
            case "BIGINT": 
            case "LONG": {
                return new PyNewLongScalarFunction(fname, configJson);
            }
            case "FLOAT": {
                return new PyFloatScalarFunction(fname, configJson);
            }
            case "DOUBLE": {
                return new PyNewDoubleScalarFunction(fname, configJson);
            }
            case "BIGDECIMAL": 
            case "BIG_DEC": 
            case "DECIMAL": {
                return new PyBigDecimalScalarFunction(fname, configJson);
            }
            case "STRING": 
            case "VARCHAR": {
                return new PyNewStringScalarFunction(fname, configJson);
            }
            case "TIMESTAMP": 
            case "DATETIME": {
                return new PyTimestampScalarFunction(fname, configJson);
            }
        }
        throw new RuntimeException("invalid resultType:" + resultType);
    }

    public static TableFunction<Row> makeTableFunction(String fname, String configJson) {
        return new PyTableFunction(fname, configJson);
    }
}

