/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink.executor.datasource;

import com.alibaba.alink.common.io.BaseDB;
import com.alibaba.alink.common.io.MySqlDB;
import com.alibaba.alink.executor.datasource.DataSourceBase;
import com.alibaba.alink.executor.datasource.TableDataT;
import com.alibaba.alink.executor.util.JsonUtil;
import com.alibaba.alink.executor.util.ParameterUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.ml.api.misc.param.Params;
import org.apache.flink.table.api.TableSchema;

public class MysqlDataSource
implements DataSourceBase {
    static final String CONFIG_KEY_DB_NAME = "dbName";
    static final String CONFIG_KEY_IP = "ip";
    static final String CONFIG_KEY_PORT = "port";
    static final String CONFIG_KEY_USER_NAME = "userName";
    static final String CONFIG_KEY_PASSWORD = "password";
    static final String[] KEY_LIST = new String[]{"dbName", "ip", "port", "userName", "password"};
    String dbName;
    MySqlDB db;
    String jythonScript;

    @Override
    public DataSourceBase init(String config) {
        String[] values = JsonUtil.GetJsonValues(config, KEY_LIST);
        this.doInit(values);
        return this;
    }

    @Override
    public DataSourceBase init(Params parameter) {
        this.doInit(ParameterUtil.getStringValues(parameter, KEY_LIST));
        return this;
    }

    private void doInit(String[] values) {
        this.dbName = values[0];
        this.db = new MySqlDB(values[0], values[1], values[2], values[3], values[4]);
        this.jythonScript = String.format("%s('%s', '%s', '%s', '%s', '%s')", MySqlDB.class.getSimpleName(), values[0], values[1], values[2], values[3], values[4]);
    }

    @Override
    public String generateDefinitionJythonScript() {
        return this.jythonScript;
    }

    @Override
    public BaseDB getDB() {
        return this.db;
    }

    @Override
    public boolean check() throws Exception {
        return this.db.listTableNames().size() >= 0;
    }

    @Override
    public String getName() {
        return this.dbName;
    }

    /*
     * Exception decompiling
     */
    @Override
    public List<String> listProjectsImpl(String config, String prefix, Integer maxSize) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> listTables(String prefix, Integer count) throws Exception {
        try {
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : this.db.listTableNames()) {
                if (prefix != null && !s.startsWith(prefix)) continue;
                ret.add(s);
                if (count == null || ret.size() < count) continue;
                break;
            }
            ArrayList<String> arrayList = ret;
            return arrayList;
        }
        finally {
            this.db.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableDataT getTableData(String tableName, int count) throws Exception {
        try {
            TableDataT z = new TableDataT();
            TableSchema s = this.db.getTableSchema(tableName);
            z.colNames.addAll(Arrays.asList(s.getFieldNames()));
            for (TypeInformation e : s.getFieldTypes()) {
                z.colTypes.add(e.toString());
            }
            this.db.query("select * from " + tableName + " limit 100", rs -> {
                while (rs.next()) {
                    Object[] row = new Object[z.colNames.size()];
                    for (int i = 0; i < z.colNames.size(); ++i) {
                        row[i] = rs.getObject(i + 1);
                    }
                    z.records.add(row);
                }
            });
            TableDataT tableDataT = z;
            return tableDataT;
        }
        finally {
            this.db.close();
        }
    }

    @Override
    public String getTableNameFromParameters(Params p) {
        if (p.contains("tableName")) {
            return p.getString("tableName");
        }
        throw new RuntimeException("Parameter[tableName] is missing.");
    }

    @Override
    public String getProjectNameFromParameters(Params p) {
        if (p.contains(CONFIG_KEY_DB_NAME)) {
            return p.getString(CONFIG_KEY_DB_NAME);
        }
        throw new RuntimeException("Parameter[dbName] is missing.");
    }
}

