/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.alink;

import com.alibaba.alink.BaseFunctionContextBridge;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.flink.table.functions.FunctionContext;
import org.apache.flink.table.functions.TableFunction;
import org.apache.flink.util.Collector;

public class TableFunctionWrapper {
    final URL[] urls;
    final String clsName;
    protected transient URLClassLoader classLoader;
    protected transient Method[] methods;
    protected transient TableFunction impl;

    public TableFunctionWrapper(URL[] urls, String clsName) {
        this.urls = urls;
        this.clsName = clsName;
    }

    public void open(BaseFunctionContextBridge ctx) throws Exception {
        Class<?> cls = null;
        try {
            cls = Class.forName(this.clsName);
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            if (this.urls.length == 0) {
                throw e;
            }
            this.classLoader = new URLClassLoader(this.urls, this.getClass().getClassLoader());
            cls = this.classLoader.loadClass(this.clsName);
        }
        this.methods = Stream.of(cls.getDeclaredMethods()).filter(x -> x.getName().equals("eval")).filter(x -> Modifier.isPublic(x.getModifiers())).filter(x -> !Modifier.isStatic(x.getModifiers())).collect(Collectors.toList()).toArray(new Method[0]);
        if (this.methods.length == 0) {
            throw new RuntimeException("Failed to find eval method");
        }
        this.impl = (TableFunction)cls.newInstance();
        this.impl.open((FunctionContext)ctx);
    }

    public void setCollector(Collector<Object> collector) {
        if (this.impl == null) {
            throw new RuntimeException("should invoke open firstly.");
        }
        this.impl.setCollector(collector);
    }

    public Method[] getMethods() {
        return this.methods;
    }

    public TableFunction getImpl() {
        return this.impl;
    }

    public void close() throws Exception {
        if (this.impl != null) {
            this.impl.close();
        }
        this.impl = null;
        this.methods = new Method[0];
        if (this.classLoader != null) {
            this.classLoader.close();
        }
        this.classLoader = null;
    }

    public boolean isDeterministic() {
        return this.impl == null || this.impl.isDeterministic();
    }
}

