/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.serialization;

import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.common.header.Headers;
import shaded.alink.kafka011.org.apache.kafka.common.serialization.Serializer;

public interface ExtendedSerializer<T>
extends Serializer<T> {
    public byte[] serialize(String var1, Headers var2, T var3);

    public static class Wrapper<T>
    implements ExtendedSerializer<T> {
        private final Serializer<T> serializer;

        public Wrapper(Serializer<T> serializer) {
            this.serializer = serializer;
        }

        @Override
        public byte[] serialize(String topic, Headers headers, T data) {
            return this.serialize(topic, data);
        }

        @Override
        public void configure(Map<String, ?> configs, boolean isKey) {
            this.serializer.configure(configs, isKey);
        }

        @Override
        public byte[] serialize(String topic, T data) {
            return this.serializer.serialize(topic, data);
        }

        @Override
        public void close() {
            this.serializer.close();
        }

        public static <T> ExtendedSerializer<T> ensureExtended(Serializer<T> serializer) {
            return serializer == null ? null : (serializer instanceof ExtendedSerializer ? (ExtendedSerializer)serializer : new Wrapper<T>(serializer));
        }
    }
}

