/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.clients.NetworkClient;
import shaded.alink.kafka011.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka011.org.apache.kafka.common.errors.AuthenticationException;
import shaded.alink.kafka011.org.apache.kafka.common.errors.IllegalSaslStateException;
import shaded.alink.kafka011.org.apache.kafka.common.errors.UnsupportedSaslMechanismException;
import shaded.alink.kafka011.org.apache.kafka.common.network.Authenticator;
import shaded.alink.kafka011.org.apache.kafka.common.network.Mode;
import shaded.alink.kafka011.org.apache.kafka.common.network.NetworkReceive;
import shaded.alink.kafka011.org.apache.kafka.common.network.NetworkSend;
import shaded.alink.kafka011.org.apache.kafka.common.network.Send;
import shaded.alink.kafka011.org.apache.kafka.common.network.TransportLayer;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.SchemaException;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.RequestHeader;
import shaded.alink.kafka011.org.apache.kafka.common.requests.SaslHandshakeRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.SaslHandshakeResponse;
import shaded.alink.kafka011.org.apache.kafka.common.security.auth.AuthCallbackHandler;
import shaded.alink.kafka011.org.apache.kafka.common.security.auth.KafkaPrincipal;
import shaded.alink.kafka011.org.apache.kafka.common.security.auth.PrincipalBuilder;
import shaded.alink.kafka011.org.apache.kafka.common.security.authenticator.SaslClientCallbackHandler;

public class SaslClientAuthenticator
implements Authenticator {
    private static final Logger LOG = LoggerFactory.getLogger(SaslClientAuthenticator.class);
    private final Subject subject;
    private final String servicePrincipal;
    private final String host;
    private final String node;
    private final String mechanism;
    private final boolean handshakeRequestEnable;
    private SaslClient saslClient;
    private Map<String, ?> configs;
    private String clientPrincipalName;
    private AuthCallbackHandler callbackHandler;
    private TransportLayer transportLayer;
    private NetworkReceive netInBuffer;
    private Send netOutBuffer;
    private SaslState saslState;
    private SaslState pendingSaslState;
    private int correlationId;
    private RequestHeader currentRequestHeader;

    public SaslClientAuthenticator(String node, Subject subject, String servicePrincipal, String host, String mechanism, boolean handshakeRequestEnable) throws IOException {
        this.node = node;
        this.subject = subject;
        this.host = host;
        this.servicePrincipal = servicePrincipal;
        this.mechanism = mechanism;
        this.handshakeRequestEnable = handshakeRequestEnable;
        this.correlationId = -1;
    }

    @Override
    public void configure(TransportLayer transportLayer, PrincipalBuilder principalBuilder, Map<String, ?> configs) throws KafkaException {
        try {
            this.transportLayer = transportLayer;
            this.configs = configs;
            this.setSaslState(this.handshakeRequestEnable ? SaslState.SEND_HANDSHAKE_REQUEST : SaslState.INITIAL);
            this.clientPrincipalName = this.mechanism.equals("GSSAPI") ? SaslClientAuthenticator.firstPrincipal(this.subject) : null;
            this.callbackHandler = new SaslClientCallbackHandler();
            this.callbackHandler.configure(configs, Mode.CLIENT, this.subject, this.mechanism);
            this.saslClient = this.createSaslClient();
        }
        catch (Exception e) {
            throw new KafkaException("Failed to configure SaslClientAuthenticator", e);
        }
    }

    private SaslClient createSaslClient() {
        try {
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<SaslClient>(){

                @Override
                public SaslClient run() throws SaslException {
                    Object[] mechs = new String[]{SaslClientAuthenticator.this.mechanism};
                    LOG.debug("Creating SaslClient: client={};service={};serviceHostname={};mechs={}", SaslClientAuthenticator.this.clientPrincipalName, SaslClientAuthenticator.this.servicePrincipal, SaslClientAuthenticator.this.host, Arrays.toString(mechs));
                    return Sasl.createSaslClient((String[])mechs, SaslClientAuthenticator.this.clientPrincipalName, SaslClientAuthenticator.this.servicePrincipal, SaslClientAuthenticator.this.host, SaslClientAuthenticator.this.configs, SaslClientAuthenticator.this.callbackHandler);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new KafkaException("Failed to create SaslClient with mechanism " + this.mechanism, e.getCause());
        }
    }

    @Override
    public void authenticate() throws IOException {
        if (this.netOutBuffer != null && !this.flushNetOutBufferAndUpdateInterestOps()) {
            return;
        }
        switch (this.saslState) {
            case SEND_HANDSHAKE_REQUEST: {
                String clientId = (String)this.configs.get("client.id");
                SaslHandshakeRequest handshakeRequest = new SaslHandshakeRequest(this.mechanism);
                this.currentRequestHeader = new RequestHeader(ApiKeys.SASL_HANDSHAKE.id, handshakeRequest.version(), clientId, this.correlationId++);
                this.send(handshakeRequest.toSend(this.node, this.currentRequestHeader));
                this.setSaslState(SaslState.RECEIVE_HANDSHAKE_RESPONSE);
                break;
            }
            case RECEIVE_HANDSHAKE_RESPONSE: {
                byte[] responseBytes = this.receiveResponseOrToken();
                if (responseBytes == null) break;
                try {
                    this.handleKafkaResponse(this.currentRequestHeader, responseBytes);
                    this.currentRequestHeader = null;
                }
                catch (Exception e) {
                    this.setSaslState(SaslState.FAILED);
                    throw e;
                }
                this.setSaslState(SaslState.INITIAL);
            }
            case INITIAL: {
                this.sendSaslToken(new byte[0], true);
                this.setSaslState(SaslState.INTERMEDIATE);
                break;
            }
            case INTERMEDIATE: {
                byte[] serverToken = this.receiveResponseOrToken();
                if (serverToken != null) {
                    this.sendSaslToken(serverToken, false);
                }
                if (!this.saslClient.isComplete()) break;
                this.setSaslState(SaslState.COMPLETE);
                this.transportLayer.removeInterestOps(4);
                break;
            }
            case COMPLETE: {
                break;
            }
            case FAILED: {
                throw new IOException("SASL handshake failed");
            }
        }
    }

    private void setSaslState(SaslState saslState) {
        if (this.netOutBuffer != null && !this.netOutBuffer.completed()) {
            this.pendingSaslState = saslState;
        } else {
            this.pendingSaslState = null;
            this.saslState = saslState;
            LOG.debug("Set SASL client state to {}", (Object)saslState);
        }
    }

    private void sendSaslToken(byte[] serverToken, boolean isInitial) throws IOException {
        byte[] saslToken;
        if (!this.saslClient.isComplete() && (saslToken = this.createSaslToken(serverToken, isInitial)) != null) {
            this.send(new NetworkSend(this.node, ByteBuffer.wrap(saslToken)));
        }
    }

    private void send(Send send) throws IOException {
        try {
            this.netOutBuffer = send;
            this.flushNetOutBufferAndUpdateInterestOps();
        }
        catch (IOException e) {
            this.setSaslState(SaslState.FAILED);
            throw e;
        }
    }

    private boolean flushNetOutBufferAndUpdateInterestOps() throws IOException {
        boolean flushedCompletely = this.flushNetOutBuffer();
        if (flushedCompletely) {
            this.transportLayer.removeInterestOps(4);
            if (this.pendingSaslState != null) {
                this.setSaslState(this.pendingSaslState);
            }
        } else {
            this.transportLayer.addInterestOps(4);
        }
        return flushedCompletely;
    }

    private byte[] receiveResponseOrToken() throws IOException {
        if (this.netInBuffer == null) {
            this.netInBuffer = new NetworkReceive(this.node);
        }
        this.netInBuffer.readFrom(this.transportLayer);
        byte[] serverPacket = null;
        if (this.netInBuffer.complete()) {
            this.netInBuffer.payload().rewind();
            serverPacket = new byte[this.netInBuffer.payload().remaining()];
            this.netInBuffer.payload().get(serverPacket, 0, serverPacket.length);
            this.netInBuffer = null;
        }
        return serverPacket;
    }

    @Override
    public Principal principal() {
        return new KafkaPrincipal("User", this.clientPrincipalName);
    }

    @Override
    public boolean complete() {
        return this.saslState == SaslState.COMPLETE;
    }

    @Override
    public void close() throws IOException {
        if (this.saslClient != null) {
            this.saslClient.dispose();
        }
        if (this.callbackHandler != null) {
            this.callbackHandler.close();
        }
    }

    private byte[] createSaslToken(final byte[] saslToken, boolean isInitial) throws SaslException {
        if (saslToken == null) {
            throw new SaslException("Error authenticating with the Kafka Broker: received a `null` saslToken.");
        }
        try {
            if (isInitial && !this.saslClient.hasInitialResponse()) {
                return saslToken;
            }
            return Subject.doAs(this.subject, new PrivilegedExceptionAction<byte[]>(){

                @Override
                public byte[] run() throws SaslException {
                    return SaslClientAuthenticator.this.saslClient.evaluateChallenge(saslToken);
                }
            });
        }
        catch (PrivilegedActionException e) {
            String error = "An error: (" + e + ") occurred when evaluating SASL token received from the Kafka Broker.";
            String unknownServerErrorText = "(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)";
            if (e.toString().contains("(Mechanism level: Server not found in Kerberos database (7) - UNKNOWN_SERVER)")) {
                error = error + " This may be caused by Java's being unable to resolve the Kafka Broker's hostname correctly. You may want to try to adding '-Dsun.net.spi.nameservice.provider.1=dns,sun' to your client's JVMFLAGS environment. Users must configure FQDN of kafka brokers when authenticating using SASL and `socketChannel.socket().getInetAddress().getHostName()` must match the hostname in `principal/hostname@realm`";
            }
            error = error + " Kafka Client will go to AUTH_FAILED state.";
            throw new SaslException(error, e.getCause());
        }
    }

    private boolean flushNetOutBuffer() throws IOException {
        if (!this.netOutBuffer.completed()) {
            this.netOutBuffer.writeTo(this.transportLayer);
        }
        return this.netOutBuffer.completed();
    }

    private void handleKafkaResponse(RequestHeader requestHeader, byte[] responseBytes) {
        ApiKeys apiKey;
        AbstractResponse response;
        try {
            response = NetworkClient.parseResponse(ByteBuffer.wrap(responseBytes), requestHeader);
            apiKey = ApiKeys.forId(requestHeader.apiKey());
        }
        catch (IllegalArgumentException | SchemaException e) {
            LOG.debug("Invalid SASL mechanism response, server may be expecting only GSSAPI tokens");
            throw new AuthenticationException("Invalid SASL mechanism response", e);
        }
        switch (apiKey) {
            case SASL_HANDSHAKE: {
                this.handleSaslHandshakeResponse((SaslHandshakeResponse)response);
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected API key during handshake: " + (Object)((Object)apiKey));
            }
        }
    }

    private void handleSaslHandshakeResponse(SaslHandshakeResponse response) {
        Errors error = response.error();
        switch (error) {
            case NONE: {
                break;
            }
            case UNSUPPORTED_SASL_MECHANISM: {
                throw new UnsupportedSaslMechanismException(String.format("Client SASL mechanism '%s' not enabled in the server, enabled mechanisms are %s", this.mechanism, response.enabledMechanisms()));
            }
            case ILLEGAL_SASL_STATE: {
                throw new IllegalSaslStateException(String.format("Unexpected handshake request with client mechanism %s, enabled mechanisms are %s", this.mechanism, response.enabledMechanisms()));
            }
            default: {
                throw new AuthenticationException(String.format("Unknown error code %s, client mechanism is %s, enabled mechanisms are %s", new Object[]{response.error(), this.mechanism, response.enabledMechanisms()}));
            }
        }
    }

    static final String firstPrincipal(Subject subject) {
        Set<Principal> principals;
        Set<Principal> set = principals = subject.getPrincipals();
        synchronized (set) {
            Iterator<Principal> iterator = principals.iterator();
            if (iterator.hasNext()) {
                return iterator.next().getName();
            }
            throw new KafkaException("Principal could not be determined from Subject, this may be a transient failure due to Kerberos re-login");
        }
    }

    public static enum SaslState {
        SEND_HANDSHAKE_REQUEST,
        RECEIVE_HANDSHAKE_RESPONSE,
        INITIAL,
        INTERMEDIATE,
        COMPLETE,
        FAILED;

    }
}

