/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.TransactionResult;
import shaded.alink.kafka011.org.apache.kafka.common.requests.WriteTxnMarkersResponse;
import shaded.alink.kafka011.org.apache.kafka.common.utils.CollectionUtils;

public class WriteTxnMarkersRequest
extends AbstractRequest {
    private static final String COORDINATOR_EPOCH_KEY_NAME = "coordinator_epoch";
    private static final String TXN_MARKER_ENTRY_KEY_NAME = "transaction_markers";
    private static final String PRODUCER_ID_KEY_NAME = "producer_id";
    private static final String PRODUCER_EPOCH_KEY_NAME = "producer_epoch";
    private static final String TRANSACTION_RESULT_KEY_NAME = "transaction_result";
    private static final String TOPIC_PARTITIONS_KEY_NAME = "topics";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITIONS_KEY_NAME = "partitions";
    private final List<TxnMarkerEntry> markers;

    private WriteTxnMarkersRequest(short version, List<TxnMarkerEntry> markers) {
        super(version);
        this.markers = markers;
    }

    public WriteTxnMarkersRequest(Struct struct, short version) {
        super(version);
        Object[] markersArray;
        ArrayList<TxnMarkerEntry> markers = new ArrayList<TxnMarkerEntry>();
        for (Object markerObj : markersArray = struct.getArray(TXN_MARKER_ENTRY_KEY_NAME)) {
            Object[] topicPartitionsArray;
            Struct markerStruct = (Struct)markerObj;
            long producerId = markerStruct.getLong(PRODUCER_ID_KEY_NAME);
            short producerEpoch = markerStruct.getShort(PRODUCER_EPOCH_KEY_NAME);
            int coordinatorEpoch = markerStruct.getInt(COORDINATOR_EPOCH_KEY_NAME);
            TransactionResult result = TransactionResult.forId(markerStruct.getBoolean(TRANSACTION_RESULT_KEY_NAME));
            ArrayList<TopicPartition> partitions = new ArrayList<TopicPartition>();
            for (Object topicPartitionObj : topicPartitionsArray = markerStruct.getArray(TOPIC_PARTITIONS_KEY_NAME)) {
                Struct topicPartitionStruct = (Struct)topicPartitionObj;
                String topic = topicPartitionStruct.getString(TOPIC_KEY_NAME);
                for (Object partitionObj : topicPartitionStruct.getArray(PARTITIONS_KEY_NAME)) {
                    partitions.add(new TopicPartition(topic, (Integer)partitionObj));
                }
            }
            markers.add(new TxnMarkerEntry(producerId, producerEpoch, coordinatorEpoch, result, partitions));
        }
        this.markers = markers;
    }

    public List<TxnMarkerEntry> markers() {
        return this.markers;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.WRITE_TXN_MARKERS.requestSchema(this.version()));
        Object[] markersArray = new Object[this.markers.size()];
        int i = 0;
        for (TxnMarkerEntry entry : this.markers) {
            Struct markerStruct = struct.instance(TXN_MARKER_ENTRY_KEY_NAME);
            markerStruct.set(PRODUCER_ID_KEY_NAME, (Object)entry.producerId);
            markerStruct.set(PRODUCER_EPOCH_KEY_NAME, (Object)entry.producerEpoch);
            markerStruct.set(COORDINATOR_EPOCH_KEY_NAME, (Object)entry.coordinatorEpoch);
            markerStruct.set(TRANSACTION_RESULT_KEY_NAME, (Object)((TxnMarkerEntry)entry).result.id);
            Map<String, List<Integer>> mappedPartitions = CollectionUtils.groupDataByTopic(entry.partitions);
            Object[] partitionsArray = new Object[mappedPartitions.size()];
            int j = 0;
            for (Map.Entry<String, List<Integer>> topicAndPartitions : mappedPartitions.entrySet()) {
                Struct topicPartitionsStruct = markerStruct.instance(TOPIC_PARTITIONS_KEY_NAME);
                topicPartitionsStruct.set(TOPIC_KEY_NAME, (Object)topicAndPartitions.getKey());
                topicPartitionsStruct.set(PARTITIONS_KEY_NAME, (Object)topicAndPartitions.getValue().toArray());
                partitionsArray[j++] = topicPartitionsStruct;
            }
            markerStruct.set(TOPIC_PARTITIONS_KEY_NAME, (Object)partitionsArray);
            markersArray[i++] = markerStruct;
        }
        struct.set(TXN_MARKER_ENTRY_KEY_NAME, (Object)markersArray);
        return struct;
    }

    @Override
    public WriteTxnMarkersResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        HashMap<Long, Map<TopicPartition, Errors>> errors = new HashMap<Long, Map<TopicPartition, Errors>>(this.markers.size());
        for (TxnMarkerEntry entry : this.markers) {
            HashMap<TopicPartition, Errors> errorsPerPartition = new HashMap<TopicPartition, Errors>(entry.partitions.size());
            for (TopicPartition partition : entry.partitions) {
                errorsPerPartition.put(partition, error);
            }
            errors.put(entry.producerId, errorsPerPartition);
        }
        return new WriteTxnMarkersResponse(errors);
    }

    public static WriteTxnMarkersRequest parse(ByteBuffer buffer, short version) {
        return new WriteTxnMarkersRequest(ApiKeys.WRITE_TXN_MARKERS.parseRequest(version, buffer), version);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteTxnMarkersRequest that = (WriteTxnMarkersRequest)o;
        return Objects.equals(this.markers, that.markers);
    }

    public int hashCode() {
        return Objects.hash(this.markers);
    }

    public static class Builder
    extends AbstractRequest.Builder<WriteTxnMarkersRequest> {
        private final List<TxnMarkerEntry> markers;

        public Builder(List<TxnMarkerEntry> markers) {
            super(ApiKeys.WRITE_TXN_MARKERS);
            this.markers = markers;
        }

        @Override
        public WriteTxnMarkersRequest build(short version) {
            return new WriteTxnMarkersRequest(version, this.markers);
        }
    }

    public static class TxnMarkerEntry {
        private final long producerId;
        private final short producerEpoch;
        private final int coordinatorEpoch;
        private final TransactionResult result;
        private final List<TopicPartition> partitions;

        public TxnMarkerEntry(long producerId, short producerEpoch, int coordinatorEpoch, TransactionResult result, List<TopicPartition> partitions) {
            this.producerId = producerId;
            this.producerEpoch = producerEpoch;
            this.coordinatorEpoch = coordinatorEpoch;
            this.result = result;
            this.partitions = partitions;
        }

        public long producerId() {
            return this.producerId;
        }

        public short producerEpoch() {
            return this.producerEpoch;
        }

        public int coordinatorEpoch() {
            return this.coordinatorEpoch;
        }

        public TransactionResult transactionResult() {
            return this.result;
        }

        public List<TopicPartition> partitions() {
            return this.partitions;
        }

        public String toString() {
            return "TxnMarkerEntry{producerId=" + this.producerId + ", producerEpoch=" + this.producerEpoch + ", coordinatorEpoch=" + this.coordinatorEpoch + ", result=" + (Object)((Object)this.result) + ", partitions=" + this.partitions + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TxnMarkerEntry that = (TxnMarkerEntry)o;
            return this.producerId == that.producerId && this.producerEpoch == that.producerEpoch && this.coordinatorEpoch == that.coordinatorEpoch && this.result == that.result && Objects.equals(this.partitions, that.partitions);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.producerId, this.producerEpoch, this.coordinatorEpoch, this.result, this.partitions});
        }
    }
}

