/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collections;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    public ListGroupsRequest(short version) {
        super(version);
    }

    public ListGroupsRequest(Struct struct, short versionId) {
        super(versionId);
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new ListGroupsResponse(Errors.forException(e), Collections.emptyList());
            }
            case 1: {
                return new ListGroupsResponse(throttleTimeMs, Errors.forException(e), Collections.emptyList());
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LIST_GROUPS.latestVersion()));
    }

    public static ListGroupsRequest parse(ByteBuffer buffer, short version) {
        return new ListGroupsRequest(ApiKeys.LIST_GROUPS.parseRequest(version, buffer), version);
    }

    @Override
    protected Struct toStruct() {
        return new Struct(ApiKeys.LIST_GROUPS.requestSchema(this.version()));
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        public Builder() {
            super(ApiKeys.LIST_GROUPS);
        }

        @Override
        public ListGroupsRequest build(short version) {
            return new ListGroupsRequest(version);
        }

        public String toString() {
            return "(type=ListGroupsRequest)";
        }
    }
}

