/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import shaded.alink.kafka011.org.apache.kafka.common.Node;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.LeaderAndIsrResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.PartitionState;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Utils;

public class LeaderAndIsrRequest
extends AbstractRequest {
    private static final String CONTROLLER_ID_KEY_NAME = "controller_id";
    private static final String CONTROLLER_EPOCH_KEY_NAME = "controller_epoch";
    private static final String PARTITION_STATES_KEY_NAME = "partition_states";
    private static final String LIVE_LEADERS_KEY_NAME = "live_leaders";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private static final String LEADER_KEY_NAME = "leader";
    private static final String LEADER_EPOCH_KEY_NAME = "leader_epoch";
    private static final String ISR_KEY_NAME = "isr";
    private static final String ZK_VERSION_KEY_NAME = "zk_version";
    private static final String REPLICAS_KEY_NAME = "replicas";
    private static final String END_POINT_ID_KEY_NAME = "id";
    private static final String HOST_KEY_NAME = "host";
    private static final String PORT_KEY_NAME = "port";
    private final int controllerId;
    private final int controllerEpoch;
    private final Map<TopicPartition, PartitionState> partitionStates;
    private final Set<Node> liveLeaders;

    private LeaderAndIsrRequest(int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders, short version) {
        super(version);
        this.controllerId = controllerId;
        this.controllerEpoch = controllerEpoch;
        this.partitionStates = partitionStates;
        this.liveLeaders = liveLeaders;
    }

    public LeaderAndIsrRequest(Struct struct, short version) {
        super(version);
        HashMap<TopicPartition, PartitionState> partitionStates = new HashMap<TopicPartition, PartitionState>();
        for (Object partitionStateDataObj : struct.getArray(PARTITION_STATES_KEY_NAME)) {
            Struct partitionStateData = (Struct)partitionStateDataObj;
            String topic = partitionStateData.getString(TOPIC_KEY_NAME);
            int partition = partitionStateData.getInt(PARTITION_KEY_NAME);
            int controllerEpoch = partitionStateData.getInt(CONTROLLER_EPOCH_KEY_NAME);
            int leader = partitionStateData.getInt(LEADER_KEY_NAME);
            int leaderEpoch = partitionStateData.getInt(LEADER_EPOCH_KEY_NAME);
            Object[] isrArray = partitionStateData.getArray(ISR_KEY_NAME);
            ArrayList<Integer> isr = new ArrayList<Integer>(isrArray.length);
            for (Object r : isrArray) {
                isr.add((Integer)r);
            }
            int zkVersion = partitionStateData.getInt(ZK_VERSION_KEY_NAME);
            Object[] replicasArray = partitionStateData.getArray(REPLICAS_KEY_NAME);
            ArrayList<Integer> replicas = new ArrayList<Integer>(replicasArray.length);
            for (Object r : replicasArray) {
                replicas.add((Integer)r);
            }
            PartitionState partitionState = new PartitionState(controllerEpoch, leader, leaderEpoch, isr, zkVersion, replicas);
            partitionStates.put(new TopicPartition(topic, partition), partitionState);
        }
        HashSet<Node> leaders = new HashSet<Node>();
        for (Object leadersDataObj : struct.getArray(LIVE_LEADERS_KEY_NAME)) {
            Struct leadersData = (Struct)leadersDataObj;
            int id = leadersData.getInt(END_POINT_ID_KEY_NAME);
            String host = leadersData.getString(HOST_KEY_NAME);
            int port = leadersData.getInt(PORT_KEY_NAME);
            leaders.add(new Node(id, host, port));
        }
        this.controllerId = struct.getInt(CONTROLLER_ID_KEY_NAME);
        this.controllerEpoch = struct.getInt(CONTROLLER_EPOCH_KEY_NAME);
        this.partitionStates = partitionStates;
        this.liveLeaders = leaders;
    }

    @Override
    protected Struct toStruct() {
        short version = this.version();
        Struct struct = new Struct(ApiKeys.LEADER_AND_ISR.requestSchema(version));
        struct.set(CONTROLLER_ID_KEY_NAME, (Object)this.controllerId);
        struct.set(CONTROLLER_EPOCH_KEY_NAME, (Object)this.controllerEpoch);
        ArrayList<Struct> partitionStatesData = new ArrayList<Struct>(this.partitionStates.size());
        for (Map.Entry<TopicPartition, PartitionState> entry : this.partitionStates.entrySet()) {
            Struct partitionStateData = struct.instance(PARTITION_STATES_KEY_NAME);
            TopicPartition topicPartition = entry.getKey();
            partitionStateData.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            partitionStateData.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
            PartitionState partitionState = entry.getValue();
            partitionStateData.set(CONTROLLER_EPOCH_KEY_NAME, (Object)partitionState.controllerEpoch);
            partitionStateData.set(LEADER_KEY_NAME, (Object)partitionState.leader);
            partitionStateData.set(LEADER_EPOCH_KEY_NAME, (Object)partitionState.leaderEpoch);
            partitionStateData.set(ISR_KEY_NAME, (Object)partitionState.isr.toArray());
            partitionStateData.set(ZK_VERSION_KEY_NAME, (Object)partitionState.zkVersion);
            partitionStateData.set(REPLICAS_KEY_NAME, (Object)partitionState.replicas.toArray());
            partitionStatesData.add(partitionStateData);
        }
        struct.set(PARTITION_STATES_KEY_NAME, (Object)partitionStatesData.toArray());
        ArrayList<Struct> leadersData = new ArrayList<Struct>(this.liveLeaders.size());
        for (Node leader : this.liveLeaders) {
            Struct leaderData = struct.instance(LIVE_LEADERS_KEY_NAME);
            leaderData.set(END_POINT_ID_KEY_NAME, (Object)leader.id());
            leaderData.set(HOST_KEY_NAME, (Object)leader.host());
            leaderData.set(PORT_KEY_NAME, (Object)leader.port());
            leadersData.add(leaderData);
        }
        struct.set(LIVE_LEADERS_KEY_NAME, (Object)leadersData.toArray());
        return struct;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        HashMap<TopicPartition, Errors> responses = new HashMap<TopicPartition, Errors>(this.partitionStates.size());
        for (TopicPartition partition : this.partitionStates.keySet()) {
            responses.put(partition, Errors.forException(e));
        }
        short versionId = this.version();
        switch (versionId) {
            case 0: {
                return new LeaderAndIsrResponse(Errors.NONE, responses);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ApiKeys.LEADER_AND_ISR.latestVersion()));
    }

    public int controllerId() {
        return this.controllerId;
    }

    public int controllerEpoch() {
        return this.controllerEpoch;
    }

    public Map<TopicPartition, PartitionState> partitionStates() {
        return this.partitionStates;
    }

    public Set<Node> liveLeaders() {
        return this.liveLeaders;
    }

    public static LeaderAndIsrRequest parse(ByteBuffer buffer, short version) {
        return new LeaderAndIsrRequest(ApiKeys.LEADER_AND_ISR.parseRequest(version, buffer), version);
    }

    public static class Builder
    extends AbstractRequest.Builder<LeaderAndIsrRequest> {
        private final int controllerId;
        private final int controllerEpoch;
        private final Map<TopicPartition, PartitionState> partitionStates;
        private final Set<Node> liveLeaders;

        public Builder(int controllerId, int controllerEpoch, Map<TopicPartition, PartitionState> partitionStates, Set<Node> liveLeaders) {
            super(ApiKeys.LEADER_AND_ISR);
            this.controllerId = controllerId;
            this.controllerEpoch = controllerEpoch;
            this.partitionStates = partitionStates;
            this.liveLeaders = liveLeaders;
        }

        @Override
        public LeaderAndIsrRequest build(short version) {
            return new LeaderAndIsrRequest(this.controllerId, this.controllerEpoch, this.partitionStates, this.liveLeaders, version);
        }

        public String toString() {
            StringBuilder bld = new StringBuilder();
            bld.append("(type=LeaderAndIsRequest").append(", controllerId=").append(this.controllerId).append(", controllerEpoch=").append(this.controllerEpoch).append(", partitionStates=").append(this.partitionStates).append(", liveLeaders=(").append(Utils.join(this.liveLeaders, ", ")).append(")").append(")");
            return bld.toString();
        }
    }
}

