/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractRequest;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;
import shaded.alink.kafka011.org.apache.kafka.common.requests.InitProducerIdResponse;

public class InitProducerIdRequest
extends AbstractRequest {
    public static final int NO_TRANSACTION_TIMEOUT_MS = Integer.MAX_VALUE;
    private static final String TRANSACTIONAL_ID_KEY_NAME = "transactional_id";
    private static final String TRANSACTION_TIMEOUT_KEY_NAME = "transaction_timeout_ms";
    private final String transactionalId;
    private final int transactionTimeoutMs;

    public InitProducerIdRequest(Struct struct, short version) {
        super(version);
        this.transactionalId = struct.getString(TRANSACTIONAL_ID_KEY_NAME);
        this.transactionTimeoutMs = struct.getInt(TRANSACTION_TIMEOUT_KEY_NAME);
    }

    private InitProducerIdRequest(short version, String transactionalId, int transactionTimeoutMs) {
        super(version);
        this.transactionalId = transactionalId;
        this.transactionTimeoutMs = transactionTimeoutMs;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new InitProducerIdResponse(throttleTimeMs, Errors.forException(e));
    }

    public static InitProducerIdRequest parse(ByteBuffer buffer, short version) {
        return new InitProducerIdRequest(ApiKeys.INIT_PRODUCER_ID.parseRequest(version, buffer), version);
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    public int transactionTimeoutMs() {
        return this.transactionTimeoutMs;
    }

    @Override
    protected Struct toStruct() {
        Struct struct = new Struct(ApiKeys.INIT_PRODUCER_ID.requestSchema(this.version()));
        struct.set(TRANSACTIONAL_ID_KEY_NAME, (Object)this.transactionalId);
        struct.set(TRANSACTION_TIMEOUT_KEY_NAME, (Object)this.transactionTimeoutMs);
        return struct;
    }

    public static class Builder
    extends AbstractRequest.Builder<InitProducerIdRequest> {
        private final String transactionalId;
        private final int transactionTimeoutMs;

        public Builder(String transactionalId) {
            this(transactionalId, Integer.MAX_VALUE);
        }

        public Builder(String transactionalId, int transactionTimeoutMs) {
            super(ApiKeys.INIT_PRODUCER_ID);
            if (transactionTimeoutMs <= 0) {
                throw new IllegalArgumentException("transaction timeout value is not positive: " + transactionTimeoutMs);
            }
            if (transactionalId != null && transactionalId.isEmpty()) {
                throw new IllegalArgumentException("Must set either a null or a non-empty transactional id.");
            }
            this.transactionalId = transactionalId;
            this.transactionTimeoutMs = transactionTimeoutMs;
        }

        @Override
        public InitProducerIdRequest build(short version) {
            return new InitProducerIdRequest(version, this.transactionalId, this.transactionTimeoutMs);
        }

        public String toString() {
            return "(type=InitProducerIdRequest, transactionalId=" + this.transactionalId + ", transactionTimeoutMs=" + this.transactionTimeoutMs + ")";
        }
    }
}

