/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka011.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka011.org.apache.kafka.common.requests.AbstractResponse;

public class ControlledShutdownResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private static final String PARTITIONS_REMAINING_KEY_NAME = "partitions_remaining";
    private static final String TOPIC_KEY_NAME = "topic";
    private static final String PARTITION_KEY_NAME = "partition";
    private final Errors error;
    private final Set<TopicPartition> partitionsRemaining;

    public ControlledShutdownResponse(Errors error, Set<TopicPartition> partitionsRemaining) {
        this.error = error;
        this.partitionsRemaining = partitionsRemaining;
    }

    public ControlledShutdownResponse(Struct struct) {
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
        HashSet<TopicPartition> partitions = new HashSet<TopicPartition>();
        for (Object topicPartitionObj : struct.getArray(PARTITIONS_REMAINING_KEY_NAME)) {
            Struct topicPartition = (Struct)topicPartitionObj;
            String topic = topicPartition.getString(TOPIC_KEY_NAME);
            int partition = topicPartition.getInt(PARTITION_KEY_NAME);
            partitions.add(new TopicPartition(topic, partition));
        }
        this.partitionsRemaining = partitions;
    }

    public Errors error() {
        return this.error;
    }

    public Set<TopicPartition> partitionsRemaining() {
        return this.partitionsRemaining;
    }

    public static ControlledShutdownResponse parse(ByteBuffer buffer, short version) {
        return new ControlledShutdownResponse(ApiKeys.CONTROLLED_SHUTDOWN_KEY.parseResponse(version, buffer));
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.CONTROLLED_SHUTDOWN_KEY.responseSchema(version));
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        ArrayList<Struct> partitionsRemainingList = new ArrayList<Struct>(this.partitionsRemaining.size());
        for (TopicPartition topicPartition : this.partitionsRemaining) {
            Struct topicPartitionStruct = struct.instance(PARTITIONS_REMAINING_KEY_NAME);
            topicPartitionStruct.set(TOPIC_KEY_NAME, (Object)topicPartition.topic());
            topicPartitionStruct.set(PARTITION_KEY_NAME, (Object)topicPartition.partition());
            partitionsRemainingList.add(topicPartitionStruct);
        }
        struct.set(PARTITIONS_REMAINING_KEY_NAME, (Object)partitionsRemainingList.toArray());
        return struct;
    }
}

