/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.common.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka011.org.apache.kafka.common.network.ChannelBuilder;
import shaded.alink.kafka011.org.apache.kafka.common.network.ChannelBuilders;
import shaded.alink.kafka011.org.apache.kafka.common.network.DefaultAuthenticator;
import shaded.alink.kafka011.org.apache.kafka.common.network.KafkaChannel;
import shaded.alink.kafka011.org.apache.kafka.common.network.Mode;
import shaded.alink.kafka011.org.apache.kafka.common.network.SslTransportLayer;
import shaded.alink.kafka011.org.apache.kafka.common.security.auth.PrincipalBuilder;
import shaded.alink.kafka011.org.apache.kafka.common.security.ssl.SslFactory;

public class SslChannelBuilder
implements ChannelBuilder {
    private static final Logger log = LoggerFactory.getLogger(SslChannelBuilder.class);
    private SslFactory sslFactory;
    private PrincipalBuilder principalBuilder;
    private Mode mode;
    private Map<String, ?> configs;

    public SslChannelBuilder(Mode mode) {
        this.mode = mode;
    }

    @Override
    public void configure(Map<String, ?> configs) throws KafkaException {
        try {
            this.configs = configs;
            this.sslFactory = new SslFactory(this.mode);
            this.sslFactory.configure(this.configs);
            this.principalBuilder = ChannelBuilders.createPrincipalBuilder(configs);
        }
        catch (Exception e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public KafkaChannel buildChannel(String id, SelectionKey key, int maxReceiveSize) throws KafkaException {
        try {
            SslTransportLayer transportLayer = this.buildTransportLayer(this.sslFactory, id, key, this.peerHost(key));
            DefaultAuthenticator authenticator = new DefaultAuthenticator();
            authenticator.configure(transportLayer, this.principalBuilder, this.configs);
            return new KafkaChannel(id, transportLayer, authenticator, maxReceiveSize);
        }
        catch (Exception e) {
            log.info("Failed to create channel due to ", e);
            throw new KafkaException(e);
        }
    }

    @Override
    public void close() {
        this.principalBuilder.close();
    }

    protected SslTransportLayer buildTransportLayer(SslFactory sslFactory, String id, SelectionKey key, String host) throws IOException {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return SslTransportLayer.create(id, key, sslFactory.createSslEngine(host, socketChannel.socket().getPort()));
    }

    private String peerHost(SelectionKey key) {
        SocketChannel socketChannel = (SocketChannel)key.channel();
        return new InetSocketAddress(socketChannel.socket().getInetAddress(), 0).getHostString();
    }
}

