/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients.consumer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.internals.AbstractPartitionAssignor;
import shaded.alink.kafka011.org.apache.kafka.clients.consumer.internals.PartitionAssignor;
import shaded.alink.kafka011.org.apache.kafka.common.TopicPartition;
import shaded.alink.kafka011.org.apache.kafka.common.utils.CircularIterator;
import shaded.alink.kafka011.org.apache.kafka.common.utils.Utils;

public class RoundRobinAssignor
extends AbstractPartitionAssignor {
    @Override
    public Map<String, List<TopicPartition>> assign(Map<String, Integer> partitionsPerTopic, Map<String, PartitionAssignor.Subscription> subscriptions) {
        HashMap<String, List<TopicPartition>> assignment = new HashMap<String, List<TopicPartition>>();
        for (String memberId : subscriptions.keySet()) {
            assignment.put(memberId, new ArrayList());
        }
        CircularIterator<String> assigner = new CircularIterator<String>(Utils.sorted(subscriptions.keySet()));
        for (TopicPartition partition : this.allPartitionsSorted(partitionsPerTopic, subscriptions)) {
            String topic = partition.topic();
            while (!subscriptions.get(assigner.peek()).topics().contains(topic)) {
                assigner.next();
            }
            ((List)assignment.get(assigner.next())).add(partition);
        }
        return assignment;
    }

    public List<TopicPartition> allPartitionsSorted(Map<String, Integer> partitionsPerTopic, Map<String, PartitionAssignor.Subscription> subscriptions) {
        TreeSet<String> topics = new TreeSet<String>();
        for (PartitionAssignor.Subscription subscription : subscriptions.values()) {
            topics.addAll(subscription.topics());
        }
        ArrayList<TopicPartition> allPartitions = new ArrayList<TopicPartition>();
        for (String topic : topics) {
            Integer numPartitionsForTopic = partitionsPerTopic.get(topic);
            if (numPartitionsForTopic == null) continue;
            allPartitions.addAll(AbstractPartitionAssignor.partitions(topic, numPartitionsForTopic));
        }
        return allPartitions;
    }

    @Override
    public String name() {
        return "roundrobin";
    }
}

