/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.kafka.clients;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka011.org.apache.kafka.clients.NetworkClient;

final class InFlightRequests {
    private final int maxInFlightRequestsPerConnection;
    private final Map<String, Deque<NetworkClient.InFlightRequest>> requests = new HashMap<String, Deque<NetworkClient.InFlightRequest>>();

    public InFlightRequests(int maxInFlightRequestsPerConnection) {
        this.maxInFlightRequestsPerConnection = maxInFlightRequestsPerConnection;
    }

    public void add(NetworkClient.InFlightRequest request) {
        String destination = request.destination;
        Deque<NetworkClient.InFlightRequest> reqs = this.requests.get(destination);
        if (reqs == null) {
            reqs = new ArrayDeque<NetworkClient.InFlightRequest>();
            this.requests.put(destination, reqs);
        }
        reqs.addFirst(request);
    }

    private Deque<NetworkClient.InFlightRequest> requestQueue(String node) {
        Deque<NetworkClient.InFlightRequest> reqs = this.requests.get(node);
        if (reqs == null || reqs.isEmpty()) {
            throw new IllegalStateException("There are no in-flight requests for node " + node);
        }
        return reqs;
    }

    public NetworkClient.InFlightRequest completeNext(String node) {
        return this.requestQueue(node).pollLast();
    }

    public NetworkClient.InFlightRequest lastSent(String node) {
        return this.requestQueue(node).peekFirst();
    }

    public NetworkClient.InFlightRequest completeLastSent(String node) {
        return this.requestQueue(node).pollFirst();
    }

    public boolean canSendMore(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue == null || queue.isEmpty() || queue.peekFirst().send.completed() && queue.size() < this.maxInFlightRequestsPerConnection;
    }

    public int count(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue == null ? 0 : queue.size();
    }

    public boolean isEmpty(String node) {
        Deque<NetworkClient.InFlightRequest> queue = this.requests.get(node);
        return queue != null && !queue.isEmpty();
    }

    public int count() {
        int total = 0;
        for (Deque<NetworkClient.InFlightRequest> deque : this.requests.values()) {
            total += deque.size();
        }
        return total;
    }

    public boolean isEmpty() {
        for (Deque<NetworkClient.InFlightRequest> deque : this.requests.values()) {
            if (deque.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Iterable<NetworkClient.InFlightRequest> clearAll(String node) {
        Deque<NetworkClient.InFlightRequest> reqs = this.requests.get(node);
        if (reqs == null) {
            return Collections.emptyList();
        }
        return this.requests.remove(node);
    }

    public List<String> getNodesWithTimedOutRequests(long now, int requestTimeout) {
        LinkedList<String> nodeIds = new LinkedList<String>();
        for (Map.Entry<String, Deque<NetworkClient.InFlightRequest>> requestEntry : this.requests.entrySet()) {
            String nodeId = requestEntry.getKey();
            Deque<NetworkClient.InFlightRequest> deque = requestEntry.getValue();
            if (deque.isEmpty()) continue;
            NetworkClient.InFlightRequest request = deque.peekLast();
            long timeSinceSend = now - request.sendTimeMs;
            if (timeSinceSend <= (long)requestTimeout) continue;
            nodeIds.add(nodeId);
        }
        return nodeIds;
    }
}

