/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;

@Internal
public class ExceptionProxy {
    private final Thread toInterrupt;
    private final AtomicReference<Throwable> exception;

    public ExceptionProxy(@Nullable Thread toInterrupt) {
        this.toInterrupt = toInterrupt;
        this.exception = new AtomicReference();
    }

    public void reportError(Throwable t) {
        if (t != null && this.exception.compareAndSet(null, t) && this.toInterrupt != null) {
            this.toInterrupt.interrupt();
        }
    }

    public void checkAndThrowException() throws Exception {
        Throwable t = this.exception.get();
        if (t != null) {
            if (t instanceof Exception) {
                throw (Exception)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new Exception(t);
        }
    }
}

