/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.functions.RuntimeContext;
import org.apache.flink.api.common.io.ratelimiting.FlinkConnectorRateLimiter;
import org.apache.flink.api.common.serialization.DeserializationSchema;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.streaming.api.functions.AssignerWithPeriodicWatermarks;
import org.apache.flink.streaming.api.functions.AssignerWithPunctuatedWatermarks;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.operators.StreamingRuntimeContext;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.PropertiesUtil;
import org.apache.flink.util.SerializedValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.FlinkKafkaConsumerBase;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.KafkaDeserializationSchema;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.config.OffsetCommitMode;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internal.Kafka09Fetcher;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internal.Kafka09PartitionDiscoverer;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.AbstractFetcher;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.AbstractPartitionDiscoverer;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaDeserializationSchemaWrapper;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicPartition;
import shaded.alink.kafka011.org.apache.flink.streaming.connectors.kafka.internals.KafkaTopicsDescriptor;
import shaded.alink.kafka011.org.apache.kafka.common.serialization.ByteArrayDeserializer;

@PublicEvolving
public class FlinkKafkaConsumer09<T>
extends FlinkKafkaConsumerBase<T> {
    private static final long serialVersionUID = 2324564345203409112L;
    private static final Logger LOG = LoggerFactory.getLogger(FlinkKafkaConsumer09.class);
    public static final String KEY_POLL_TIMEOUT = "flink.poll-timeout";
    public static final long DEFAULT_POLL_TIMEOUT = 100L;
    protected final Properties properties;
    protected final long pollTimeout;
    private FlinkConnectorRateLimiter rateLimiter;

    public FlinkKafkaConsumer09(String topic, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(Collections.singletonList(topic), valueDeserializer, props);
    }

    public FlinkKafkaConsumer09(String topic, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(Collections.singletonList(topic), deserializer, props);
    }

    public FlinkKafkaConsumer09(List<String> topics, DeserializationSchema<T> deserializer, Properties props) {
        this(topics, new KafkaDeserializationSchemaWrapper<T>(deserializer), props);
    }

    public FlinkKafkaConsumer09(List<String> topics, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(topics, null, deserializer, props);
    }

    @PublicEvolving
    public FlinkKafkaConsumer09(Pattern subscriptionPattern, DeserializationSchema<T> valueDeserializer, Properties props) {
        this(subscriptionPattern, new KafkaDeserializationSchemaWrapper<T>(valueDeserializer), props);
    }

    @PublicEvolving
    public FlinkKafkaConsumer09(Pattern subscriptionPattern, KafkaDeserializationSchema<T> deserializer, Properties props) {
        this(null, subscriptionPattern, deserializer, props);
    }

    private FlinkKafkaConsumer09(List<String> topics, Pattern subscriptionPattern, KafkaDeserializationSchema<T> deserializer, Properties props) {
        super(topics, subscriptionPattern, deserializer, PropertiesUtil.getLong((Properties)((Properties)Preconditions.checkNotNull((Object)props, (String)"props")), (String)"flink.partition-discovery.interval-millis", (long)Long.MIN_VALUE), !PropertiesUtil.getBoolean((Properties)props, (String)"flink.disable-metrics", (boolean)false));
        this.properties = props;
        FlinkKafkaConsumer09.setDeserializer(this.properties);
        try {
            this.pollTimeout = this.properties.containsKey(KEY_POLL_TIMEOUT) ? Long.parseLong(this.properties.getProperty(KEY_POLL_TIMEOUT)) : 100L;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot parse poll timeout for 'flink.poll-timeout'", e);
        }
    }

    @Override
    protected AbstractFetcher<T, ?> createFetcher(SourceFunction.SourceContext<T> sourceContext, Map<KafkaTopicPartition, Long> assignedPartitionsWithInitialOffsets, SerializedValue<AssignerWithPeriodicWatermarks<T>> watermarksPeriodic, SerializedValue<AssignerWithPunctuatedWatermarks<T>> watermarksPunctuated, StreamingRuntimeContext runtimeContext, OffsetCommitMode offsetCommitMode, MetricGroup consumerMetricGroup, boolean useMetrics) throws Exception {
        FlinkKafkaConsumer09.adjustAutoCommitConfig(this.properties, offsetCommitMode);
        if (this.rateLimiter != null) {
            this.rateLimiter.open((RuntimeContext)runtimeContext);
        }
        return new Kafka09Fetcher<T>(sourceContext, assignedPartitionsWithInitialOffsets, watermarksPeriodic, watermarksPunctuated, runtimeContext.getProcessingTimeService(), runtimeContext.getExecutionConfig().getAutoWatermarkInterval(), runtimeContext.getUserCodeClassLoader(), runtimeContext.getTaskNameWithSubtasks(), this.deserializer, this.properties, this.pollTimeout, runtimeContext.getMetricGroup(), consumerMetricGroup, useMetrics, this.rateLimiter);
    }

    @Override
    protected AbstractPartitionDiscoverer createPartitionDiscoverer(KafkaTopicsDescriptor topicsDescriptor, int indexOfThisSubtask, int numParallelSubtasks) {
        return new Kafka09PartitionDiscoverer(topicsDescriptor, indexOfThisSubtask, numParallelSubtasks, this.properties);
    }

    @Override
    protected boolean getIsAutoCommitEnabled() {
        return PropertiesUtil.getBoolean((Properties)this.properties, (String)"enable.auto.commit", (boolean)true) && PropertiesUtil.getLong((Properties)this.properties, (String)"auto.commit.interval.ms", (long)5000L) > 0L;
    }

    @Override
    protected Map<KafkaTopicPartition, Long> fetchOffsetsWithTimestamp(Collection<KafkaTopicPartition> partitions, long timestamp) {
        throw new UnsupportedOperationException("Fetching partition offsets using timestamps is only supported in Kafka versions 0.10 and above.");
    }

    private static void setDeserializer(Properties props) {
        String deSerName = ByteArrayDeserializer.class.getName();
        Object keyDeSer = props.get("key.deserializer");
        Object valDeSer = props.get("value.deserializer");
        if (keyDeSer != null && !keyDeSer.equals(deSerName)) {
            LOG.warn("Ignoring configured key DeSerializer ({})", (Object)"key.deserializer");
        }
        if (valDeSer != null && !valDeSer.equals(deSerName)) {
            LOG.warn("Ignoring configured value DeSerializer ({})", (Object)"value.deserializer");
        }
        props.put("key.deserializer", deSerName);
        props.put("value.deserializer", deSerName);
    }

    public void setRateLimiter(FlinkConnectorRateLimiter kafkaRateLimiter) {
        this.rateLimiter = kafkaRateLimiter;
    }

    public FlinkConnectorRateLimiter getRateLimiter() {
        return this.rateLimiter;
    }
}

