/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.security.authenticator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginException;
import shaded.alink.kafka010.org.apache.kafka.common.config.types.Password;
import shaded.alink.kafka010.org.apache.kafka.common.network.LoginType;
import shaded.alink.kafka010.org.apache.kafka.common.security.auth.Login;
import shaded.alink.kafka010.org.apache.kafka.common.security.authenticator.DefaultLogin;
import shaded.alink.kafka010.org.apache.kafka.common.security.kerberos.KerberosLogin;

public class LoginManager {
    private static final EnumMap<LoginType, LoginManager> LOGIN_TYPE_INSTANCES = new EnumMap(LoginType.class);
    private static final Map<Password, LoginManager> JAAS_CONF_INSTANCES = new HashMap<Password, LoginManager>();
    private final Login login;
    private final Object cacheKey;
    private int refCount;

    private LoginManager(LoginType loginType, boolean hasKerberos, Map<String, ?> configs, Configuration jaasConfig, Password jaasConfigValue) throws IOException, LoginException {
        this.cacheKey = jaasConfigValue != null ? jaasConfigValue : loginType;
        String loginContext = loginType.contextName();
        this.login = hasKerberos ? new KerberosLogin() : new DefaultLogin();
        this.login.configure(configs, jaasConfig, loginContext);
        this.login.login();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LoginManager acquireLoginManager(LoginType loginType, boolean hasKerberos, Map<String, ?> configs, Configuration jaasConfig) throws IOException, LoginException {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            LoginManager loginManager;
            Password jaasConfigValue = (Password)configs.get("sasl.jaas.config");
            if (loginType == LoginType.CLIENT && jaasConfigValue != null) {
                loginManager = JAAS_CONF_INSTANCES.get(jaasConfigValue);
                if (loginManager == null) {
                    loginManager = new LoginManager(loginType, hasKerberos, configs, jaasConfig, jaasConfigValue);
                    JAAS_CONF_INSTANCES.put(jaasConfigValue, loginManager);
                }
            } else {
                loginManager = LOGIN_TYPE_INSTANCES.get((Object)loginType);
                if (loginManager == null) {
                    loginManager = new LoginManager(loginType, hasKerberos, configs, jaasConfig, jaasConfigValue);
                    LOGIN_TYPE_INSTANCES.put(loginType, loginManager);
                }
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return loginManager.acquire();
        }
    }

    public Subject subject() {
        return this.login.subject();
    }

    public String serviceName() {
        return this.login.serviceName();
    }

    private LoginManager acquire() {
        ++this.refCount;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            if (this.refCount == 0) {
                throw new IllegalStateException("release called on LoginManager with refCount == 0");
            }
            if (this.refCount == 1) {
                if (this.cacheKey instanceof Password) {
                    JAAS_CONF_INSTANCES.remove(this.cacheKey);
                } else {
                    LOGIN_TYPE_INSTANCES.remove(this.cacheKey);
                }
                this.login.close();
            }
            --this.refCount;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAll() {
        Class<LoginManager> clazz = LoginManager.class;
        synchronized (LoginManager.class) {
            for (LoginType loginType : new ArrayList<LoginType>(LOGIN_TYPE_INSTANCES.keySet())) {
                LoginManager.LOGIN_TYPE_INSTANCES.remove((Object)((Object)loginType)).login.close();
            }
            for (Password password : new ArrayList<Password>(JAAS_CONF_INSTANCES.keySet())) {
                LoginManager.JAAS_CONF_INSTANCES.remove((Object)password).login.close();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }
}

