/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ProtoUtils;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractResponse;

public class ApiVersionsResponse
extends AbstractResponse {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentResponseSchema(ApiKeys.API_VERSIONS.id);
    public static final ApiVersionsResponse API_VERSIONS_RESPONSE = ApiVersionsResponse.createApiVersionsResponse();
    public static final String ERROR_CODE_KEY_NAME = "error_code";
    public static final String API_VERSIONS_KEY_NAME = "api_versions";
    public static final String API_KEY_NAME = "api_key";
    public static final String MIN_VERSION_KEY_NAME = "min_version";
    public static final String MAX_VERSION_KEY_NAME = "max_version";
    private final short errorCode;
    private final Map<Short, ApiVersion> apiKeyToApiVersion;

    public ApiVersionsResponse(short errorCode, List<ApiVersion> apiVersions) {
        super(new Struct(CURRENT_SCHEMA));
        this.struct.set(ERROR_CODE_KEY_NAME, (Object)errorCode);
        ArrayList<Struct> apiVersionList = new ArrayList<Struct>();
        for (ApiVersion apiVersion : apiVersions) {
            Struct apiVersionStruct = this.struct.instance(API_VERSIONS_KEY_NAME);
            apiVersionStruct.set(API_KEY_NAME, (Object)apiVersion.apiKey);
            apiVersionStruct.set(MIN_VERSION_KEY_NAME, (Object)apiVersion.minVersion);
            apiVersionStruct.set(MAX_VERSION_KEY_NAME, (Object)apiVersion.maxVersion);
            apiVersionList.add(apiVersionStruct);
        }
        this.struct.set(API_VERSIONS_KEY_NAME, (Object)apiVersionList.toArray());
        this.errorCode = errorCode;
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(apiVersions);
    }

    public ApiVersionsResponse(Struct struct) {
        super(struct);
        this.errorCode = struct.getShort(ERROR_CODE_KEY_NAME);
        ArrayList<ApiVersion> tempApiVersions = new ArrayList<ApiVersion>();
        for (Object apiVersionsObj : struct.getArray(API_VERSIONS_KEY_NAME)) {
            Struct apiVersionStruct = (Struct)apiVersionsObj;
            short apiKey = apiVersionStruct.getShort(API_KEY_NAME);
            short minVersion = apiVersionStruct.getShort(MIN_VERSION_KEY_NAME);
            short maxVersion = apiVersionStruct.getShort(MAX_VERSION_KEY_NAME);
            tempApiVersions.add(new ApiVersion(apiKey, minVersion, maxVersion));
        }
        this.apiKeyToApiVersion = this.buildApiKeyToApiVersion(tempApiVersions);
    }

    public Collection<ApiVersion> apiVersions() {
        return this.apiKeyToApiVersion.values();
    }

    public ApiVersion apiVersion(short apiKey) {
        return this.apiKeyToApiVersion.get(apiKey);
    }

    public short errorCode() {
        return this.errorCode;
    }

    public static ApiVersionsResponse parse(ByteBuffer buffer) {
        return new ApiVersionsResponse(CURRENT_SCHEMA.read(buffer));
    }

    public static ApiVersionsResponse fromError(Errors error) {
        return new ApiVersionsResponse(error.code(), Collections.emptyList());
    }

    private static ApiVersionsResponse createApiVersionsResponse() {
        ArrayList<ApiVersion> versionList = new ArrayList<ApiVersion>();
        for (ApiKeys apiKey : ApiKeys.values()) {
            versionList.add(new ApiVersion(apiKey.id, ProtoUtils.oldestVersion(apiKey.id), ProtoUtils.latestVersion(apiKey.id)));
        }
        return new ApiVersionsResponse(Errors.NONE.code(), versionList);
    }

    private Map<Short, ApiVersion> buildApiKeyToApiVersion(List<ApiVersion> apiVersions) {
        HashMap<Short, ApiVersion> tempApiIdToApiVersion = new HashMap<Short, ApiVersion>();
        for (ApiVersion apiVersion : apiVersions) {
            tempApiIdToApiVersion.put(apiVersion.apiKey, apiVersion);
        }
        return tempApiIdToApiVersion;
    }

    public static final class ApiVersion {
        public final short apiKey;
        public final short minVersion;
        public final short maxVersion;

        public ApiVersion(short apiKey, short minVersion, short maxVersion) {
            this.apiKey = apiKey;
            this.minVersion = minVersion;
            this.maxVersion = maxVersion;
        }

        public String toString() {
            return "ApiVersion(apiKey=" + this.apiKey + ", minVersion=" + this.minVersion + ", maxVersion= " + this.maxVersion + ")";
        }
    }
}

