/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.requests;

import shaded.alink.kafka010.org.apache.kafka.common.network.NetworkSend;
import shaded.alink.kafka010.org.apache.kafka.common.network.Send;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka010.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka010.org.apache.kafka.common.requests.AbstractRequestResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ApiVersionsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ControlledShutdownResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.CreateTopicsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.DeleteTopicsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.DescribeGroupsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.FetchResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.GroupCoordinatorResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.HeartbeatResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.JoinGroupResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.LeaderAndIsrResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.LeaveGroupResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ListGroupsResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ListOffsetResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.MetadataResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.OffsetCommitResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.OffsetFetchResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ProduceResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.RequestHeader;
import shaded.alink.kafka010.org.apache.kafka.common.requests.ResponseHeader;
import shaded.alink.kafka010.org.apache.kafka.common.requests.SaslHandshakeResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.StopReplicaResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.SyncGroupResponse;
import shaded.alink.kafka010.org.apache.kafka.common.requests.UpdateMetadataResponse;

public abstract class AbstractResponse
extends AbstractRequestResponse {
    public AbstractResponse(Struct struct) {
        super(struct);
    }

    public Send toSend(String destination, RequestHeader request) {
        ResponseHeader responseHeader = new ResponseHeader(request.correlationId());
        return new NetworkSend(destination, AbstractResponse.serialize(responseHeader, this));
    }

    public static AbstractResponse getResponse(int requestId, Struct struct) {
        ApiKeys apiKey = ApiKeys.forId(requestId);
        switch (apiKey) {
            case PRODUCE: {
                return new ProduceResponse(struct);
            }
            case FETCH: {
                return new FetchResponse(struct);
            }
            case LIST_OFFSETS: {
                return new ListOffsetResponse(struct);
            }
            case METADATA: {
                return new MetadataResponse(struct);
            }
            case OFFSET_COMMIT: {
                return new OffsetCommitResponse(struct);
            }
            case OFFSET_FETCH: {
                return new OffsetFetchResponse(struct);
            }
            case GROUP_COORDINATOR: {
                return new GroupCoordinatorResponse(struct);
            }
            case JOIN_GROUP: {
                return new JoinGroupResponse(struct);
            }
            case HEARTBEAT: {
                return new HeartbeatResponse(struct);
            }
            case LEAVE_GROUP: {
                return new LeaveGroupResponse(struct);
            }
            case SYNC_GROUP: {
                return new SyncGroupResponse(struct);
            }
            case STOP_REPLICA: {
                return new StopReplicaResponse(struct);
            }
            case CONTROLLED_SHUTDOWN_KEY: {
                return new ControlledShutdownResponse(struct);
            }
            case UPDATE_METADATA_KEY: {
                return new UpdateMetadataResponse(struct);
            }
            case LEADER_AND_ISR: {
                return new LeaderAndIsrResponse(struct);
            }
            case DESCRIBE_GROUPS: {
                return new DescribeGroupsResponse(struct);
            }
            case LIST_GROUPS: {
                return new ListGroupsResponse(struct);
            }
            case SASL_HANDSHAKE: {
                return new SaslHandshakeResponse(struct);
            }
            case API_VERSIONS: {
                return new ApiVersionsResponse(struct);
            }
            case CREATE_TOPICS: {
                return new CreateTopicsResponse(struct);
            }
            case DELETE_TOPICS: {
                return new DeleteTopicsResponse(struct);
            }
        }
        throw new AssertionError((Object)String.format("ApiKey %s is not currently handled in `getResponse`, the code should be updated to do so.", new Object[]{apiKey}));
    }
}

