/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.record;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import shaded.alink.kafka010.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka010.org.apache.kafka.common.record.ByteBufferOutputStream;
import shaded.alink.kafka010.org.apache.kafka.common.record.CompressionType;
import shaded.alink.kafka010.org.apache.kafka.common.record.InvalidRecordException;
import shaded.alink.kafka010.org.apache.kafka.common.record.TimestampType;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Crc32;
import shaded.alink.kafka010.org.apache.kafka.common.utils.Utils;

public final class Record {
    public static final int CRC_OFFSET = 0;
    public static final int CRC_LENGTH = 4;
    public static final int MAGIC_OFFSET = 4;
    public static final int MAGIC_LENGTH = 1;
    public static final int ATTRIBUTES_OFFSET = 5;
    public static final int ATTRIBUTE_LENGTH = 1;
    public static final int TIMESTAMP_OFFSET = 6;
    public static final int TIMESTAMP_LENGTH = 8;
    public static final int KEY_SIZE_OFFSET_V0 = 6;
    public static final int KEY_SIZE_OFFSET_V1 = 14;
    public static final int KEY_SIZE_LENGTH = 4;
    public static final int KEY_OFFSET_V0 = 10;
    public static final int KEY_OFFSET_V1 = 18;
    public static final int VALUE_SIZE_LENGTH = 4;
    public static final int HEADER_SIZE = 6;
    public static final int RECORD_OVERHEAD_V0 = 14;
    public static final int RECORD_OVERHEAD_V1 = 22;
    public static final byte MAGIC_VALUE_V0 = 0;
    public static final byte MAGIC_VALUE_V1 = 1;
    public static final byte CURRENT_MAGIC_VALUE = 1;
    public static final int COMPRESSION_CODEC_MASK = 7;
    public static final byte TIMESTAMP_TYPE_MASK = 8;
    public static final int TIMESTAMP_TYPE_ATTRIBUTE_OFFSET = 3;
    public static final long NO_TIMESTAMP = -1L;
    private final ByteBuffer buffer;
    private final Long wrapperRecordTimestamp;
    private final TimestampType wrapperRecordTimestampType;

    public Record(ByteBuffer buffer) {
        this(buffer, null, null);
    }

    public Record(ByteBuffer buffer, Long wrapperRecordTimestamp, TimestampType wrapperRecordTimestampType) {
        this.buffer = buffer;
        this.wrapperRecordTimestamp = wrapperRecordTimestamp;
        this.wrapperRecordTimestampType = wrapperRecordTimestampType;
    }

    public long computeChecksum() {
        return Utils.computeChecksum(this.buffer, 4, this.buffer.limit() - 4);
    }

    public long checksum() {
        return Utils.readUnsignedInt(this.buffer, 0);
    }

    public boolean isValid() {
        return this.sizeInBytes() >= 4 && this.checksum() == this.computeChecksum();
    }

    public Long wrapperRecordTimestamp() {
        return this.wrapperRecordTimestamp;
    }

    public TimestampType wrapperRecordTimestampType() {
        return this.wrapperRecordTimestampType;
    }

    public void ensureValid() {
        if (!this.isValid()) {
            if (this.sizeInBytes() < 4) {
                throw new InvalidRecordException("Record is corrupt (crc could not be retrieved as the record is too small, size = " + this.sizeInBytes() + ")");
            }
            throw new InvalidRecordException("Record is corrupt (stored crc = " + this.checksum() + ", computed crc = " + this.computeChecksum() + ")");
        }
    }

    public int sizeInBytes() {
        return this.buffer.limit();
    }

    public int keySize() {
        if (this.magic() == 0) {
            return this.buffer.getInt(6);
        }
        return this.buffer.getInt(14);
    }

    public boolean hasKey() {
        return this.keySize() >= 0;
    }

    private int valueSizeOffset() {
        if (this.magic() == 0) {
            return 10 + Math.max(0, this.keySize());
        }
        return 18 + Math.max(0, this.keySize());
    }

    public int valueSize() {
        return this.buffer.getInt(this.valueSizeOffset());
    }

    public boolean hasNullValue() {
        return this.valueSize() < 0;
    }

    public byte magic() {
        return this.buffer.get(4);
    }

    public byte attributes() {
        return this.buffer.get(5);
    }

    public long timestamp() {
        if (this.magic() == 0) {
            return -1L;
        }
        if (this.wrapperRecordTimestampType == TimestampType.LOG_APPEND_TIME && this.wrapperRecordTimestamp != null) {
            return this.wrapperRecordTimestamp;
        }
        return this.buffer.getLong(6);
    }

    public TimestampType timestampType() {
        if (this.magic() == 0) {
            return TimestampType.NO_TIMESTAMP_TYPE;
        }
        return this.wrapperRecordTimestampType == null ? TimestampType.forAttributes(this.attributes()) : this.wrapperRecordTimestampType;
    }

    public CompressionType compressionType() {
        return CompressionType.forId(this.buffer.get(5) & 7);
    }

    public ByteBuffer value() {
        return Utils.sizeDelimited(this.buffer, this.valueSizeOffset());
    }

    public ByteBuffer key() {
        if (this.magic() == 0) {
            return Utils.sizeDelimited(this.buffer, 6);
        }
        return Utils.sizeDelimited(this.buffer, 14);
    }

    public ByteBuffer buffer() {
        return this.buffer;
    }

    public String toString() {
        if (this.magic() > 0) {
            return String.format("Record(magic = %d, attributes = %d, compression = %s, crc = %d, %s = %d, key = %d bytes, value = %d bytes)", new Object[]{this.magic(), this.attributes(), this.compressionType(), this.checksum(), this.timestampType(), this.timestamp(), this.key() == null ? 0 : this.key().limit(), this.value() == null ? 0 : this.value().limit()});
        }
        return String.format("Record(magic = %d, attributes = %d, compression = %s, crc = %d, key = %d bytes, value = %d bytes)", new Object[]{this.magic(), this.attributes(), this.compressionType(), this.checksum(), this.key() == null ? 0 : this.key().limit(), this.value() == null ? 0 : this.value().limit()});
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (!other.getClass().equals(Record.class)) {
            return false;
        }
        Record record = (Record)other;
        return this.buffer.equals(record.buffer);
    }

    public int hashCode() {
        return this.buffer.hashCode();
    }

    public int convertedSize(byte toMagic) {
        return Record.recordSize(toMagic, Math.max(0, this.keySize()), Math.max(0, this.valueSize()));
    }

    public Record convert(byte toMagic) {
        if (toMagic == this.magic()) {
            return this;
        }
        ByteBuffer buffer = ByteBuffer.allocate(this.convertedSize(toMagic));
        TimestampType timestampType = this.wrapperRecordTimestampType != null ? this.wrapperRecordTimestampType : TimestampType.forAttributes(this.attributes());
        this.convertTo(buffer, toMagic, this.timestamp(), timestampType);
        buffer.rewind();
        return new Record(buffer);
    }

    private void convertTo(ByteBuffer buffer, byte toMagic, long timestamp, TimestampType timestampType) {
        if (this.compressionType() != CompressionType.NONE) {
            throw new IllegalArgumentException("Cannot use convertTo for deep conversion");
        }
        Record.write(buffer, toMagic, timestamp, this.key(), this.value(), CompressionType.NONE, timestampType);
    }

    public void convertTo(DataOutputStream out, byte toMagic, long timestamp, TimestampType timestampType) throws IOException {
        if (this.compressionType() != CompressionType.NONE) {
            throw new IllegalArgumentException("Cannot use convertTo for deep conversion");
        }
        Record.write(out, toMagic, timestamp, this.key(), this.value(), CompressionType.NONE, timestampType);
    }

    public static Record create(byte magic, long timestamp, byte[] key, byte[] value, CompressionType compressionType, TimestampType timestampType) {
        int keySize = key == null ? 0 : key.length;
        int valueSize = value == null ? 0 : value.length;
        ByteBuffer buffer = ByteBuffer.allocate(Record.recordSize(magic, keySize, valueSize));
        Record.write(buffer, magic, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), compressionType, timestampType);
        buffer.rewind();
        return new Record(buffer);
    }

    public static Record create(long timestamp, byte[] key, byte[] value) {
        return Record.create((byte)1, timestamp, key, value, CompressionType.NONE, TimestampType.CREATE_TIME);
    }

    public static Record create(byte magic, long timestamp, byte[] key, byte[] value) {
        return Record.create(magic, timestamp, key, value, CompressionType.NONE, TimestampType.CREATE_TIME);
    }

    public static Record create(byte magic, TimestampType timestampType, long timestamp, byte[] key, byte[] value) {
        return Record.create(magic, timestamp, key, value, CompressionType.NONE, timestampType);
    }

    public static Record create(byte magic, long timestamp, byte[] value) {
        return Record.create(magic, timestamp, null, value, CompressionType.NONE, TimestampType.CREATE_TIME);
    }

    public static Record create(byte magic, byte[] key, byte[] value) {
        return Record.create(magic, -1L, key, value);
    }

    public static Record create(byte[] key, byte[] value) {
        return Record.create(-1L, key, value);
    }

    public static Record create(byte[] value) {
        return Record.create((byte)1, -1L, null, value, CompressionType.NONE, TimestampType.CREATE_TIME);
    }

    public static void writeCompressedRecordHeader(ByteBuffer buffer, byte magic, int recordSize, long timestamp, CompressionType compressionType, TimestampType timestampType) {
        int recordPosition = buffer.position();
        int valueSize = recordSize - Record.recordOverhead(magic);
        Record.write(buffer, magic, timestamp, null, null, compressionType, timestampType);
        buffer.putInt(recordPosition + Record.keyOffset(magic), valueSize);
        long crc = Utils.computeChecksum(buffer, recordPosition + 4, recordSize - 4);
        Utils.writeUnsignedInt(buffer, recordPosition + 0, crc);
    }

    private static void write(ByteBuffer buffer, byte magic, long timestamp, ByteBuffer key, ByteBuffer value, CompressionType compressionType, TimestampType timestampType) {
        try {
            ByteBufferOutputStream out = new ByteBufferOutputStream(buffer);
            Record.write((DataOutputStream)out, magic, timestamp, key, value, compressionType, timestampType);
        }
        catch (IOException e) {
            throw new KafkaException(e);
        }
    }

    public static long write(DataOutputStream out, byte magic, long timestamp, byte[] key, byte[] value, CompressionType compressionType, TimestampType timestampType) throws IOException {
        return Record.write(out, magic, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value), compressionType, timestampType);
    }

    private static long write(DataOutputStream out, byte magic, long timestamp, ByteBuffer key, ByteBuffer value, CompressionType compressionType, TimestampType timestampType) throws IOException {
        byte attributes = Record.computeAttributes(magic, compressionType, timestampType);
        long crc = Record.computeChecksum(magic, attributes, timestamp, key, value);
        Record.write(out, magic, crc, attributes, timestamp, key, value);
        return crc;
    }

    public static void write(DataOutputStream out, byte magic, long crc, byte attributes, long timestamp, byte[] key, byte[] value) throws IOException {
        Record.write(out, magic, crc, attributes, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value));
    }

    private static void write(DataOutputStream out, byte magic, long crc, byte attributes, long timestamp, ByteBuffer key, ByteBuffer value) throws IOException {
        int size;
        if (magic != 0 && magic != 1) {
            throw new IllegalArgumentException("Invalid magic value " + magic);
        }
        if (timestamp < 0L && timestamp != -1L) {
            throw new IllegalArgumentException("Invalid message timestamp " + timestamp);
        }
        out.writeInt((int)(crc & 0xFFFFFFFFL));
        out.writeByte(magic);
        out.writeByte(attributes);
        if (magic > 0) {
            out.writeLong(timestamp);
        }
        if (key == null) {
            out.writeInt(-1);
        } else {
            size = key.remaining();
            out.writeInt(size);
            out.write(key.array(), key.arrayOffset(), size);
        }
        if (value == null) {
            out.writeInt(-1);
        } else {
            size = value.remaining();
            out.writeInt(size);
            out.write(value.array(), value.arrayOffset(), size);
        }
    }

    public static int recordSize(byte[] key, byte[] value) {
        return Record.recordSize((byte)1, key, value);
    }

    public static int recordSize(byte magic, byte[] key, byte[] value) {
        return Record.recordSize(magic, key == null ? 0 : key.length, value == null ? 0 : value.length);
    }

    private static int recordSize(byte magic, int keySize, int valueSize) {
        return Record.recordOverhead(magic) + keySize + valueSize;
    }

    public static byte computeAttributes(byte magic, CompressionType type, TimestampType timestampType) {
        byte attributes = 0;
        if (type.id > 0) {
            attributes = (byte)(attributes | 7 & type.id);
        }
        if (magic > 0) {
            return timestampType.updateAttributes(attributes);
        }
        return attributes;
    }

    public static long computeChecksum(byte magic, byte attributes, long timestamp, byte[] key, byte[] value) {
        return Record.computeChecksum(magic, attributes, timestamp, Utils.wrapNullable(key), Utils.wrapNullable(value));
    }

    private static long computeChecksum(byte magic, byte attributes, long timestamp, ByteBuffer key, ByteBuffer value) {
        int size;
        Crc32 crc = new Crc32();
        crc.update(magic);
        crc.update(attributes);
        if (magic > 0) {
            crc.updateLong(timestamp);
        }
        if (key == null) {
            crc.updateInt(-1);
        } else {
            size = key.remaining();
            crc.updateInt(size);
            crc.update(key.array(), key.arrayOffset(), size);
        }
        if (value == null) {
            crc.updateInt(-1);
        } else {
            size = value.remaining();
            crc.updateInt(size);
            crc.update(value.array(), value.arrayOffset(), size);
        }
        return crc.getValue();
    }

    public static int recordOverhead(byte magic) {
        if (magic == 0) {
            return 14;
        }
        return 22;
    }

    private static int keyOffset(byte magic) {
        if (magic == 0) {
            return 10;
        }
        return 18;
    }
}

