/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.channels.GatheringByteChannel;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shaded.alink.kafka010.org.apache.kafka.common.KafkaException;
import shaded.alink.kafka010.org.apache.kafka.common.network.Send;

public class MultiSend
implements Send {
    private static final Logger log = LoggerFactory.getLogger(MultiSend.class);
    private final String dest;
    private final Iterator<Send> sendsIterator;
    private final long size;
    private long totalWritten = 0L;
    private Send current;

    public MultiSend(String dest, List<Send> sends) {
        this.dest = dest;
        this.sendsIterator = sends.iterator();
        this.nextSendOrDone();
        long size = 0L;
        for (Send send : sends) {
            size += send.size();
        }
        this.size = size;
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public String destination() {
        return this.dest;
    }

    @Override
    public boolean completed() {
        return this.current == null;
    }

    @Override
    public long writeTo(GatheringByteChannel channel) throws IOException {
        boolean sendComplete;
        if (this.completed()) {
            throw new KafkaException("This operation cannot be invoked on a complete request.");
        }
        int totalWrittenPerCall = 0;
        do {
            long written = this.current.writeTo(channel);
            totalWrittenPerCall = (int)((long)totalWrittenPerCall + written);
            sendComplete = this.current.completed();
            if (!sendComplete) continue;
            this.nextSendOrDone();
        } while (!this.completed() && sendComplete);
        this.totalWritten += (long)totalWrittenPerCall;
        if (this.completed() && this.totalWritten != this.size) {
            log.error("mismatch in sending bytes over socket; expected: " + this.size + " actual: " + this.totalWritten);
        }
        log.trace("Bytes written as part of multi-send call: {}, total bytes written so far: {}, expected bytes to write: {}", totalWrittenPerCall, this.totalWritten, this.size);
        return totalWrittenPerCall;
    }

    private void nextSendOrDone() {
        this.current = this.sendsIterator.hasNext() ? this.sendsIterator.next() : null;
    }
}

