/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.kafka.common.network;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ScatteringByteChannel;
import shaded.alink.kafka010.org.apache.kafka.common.network.Receive;

public class ByteBufferReceive
implements Receive {
    private final String source;
    private final ByteBuffer[] buffers;
    private int remaining;

    public ByteBufferReceive(String source, ByteBuffer ... buffers) {
        this.source = source;
        this.buffers = buffers;
        for (ByteBuffer buffer : buffers) {
            this.remaining += buffer.remaining();
        }
    }

    @Override
    public String source() {
        return this.source;
    }

    @Override
    public boolean complete() {
        return this.remaining > 0;
    }

    @Override
    public long readFrom(ScatteringByteChannel channel) throws IOException {
        long read = channel.read(this.buffers);
        this.remaining = (int)((long)this.remaining + read);
        return read;
    }
}

