/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.partitioner;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.util.Preconditions;
import shaded.alink.kafka010.org.apache.flink.streaming.connectors.kafka.partitioner.FlinkKafkaPartitioner;

@PublicEvolving
public class FlinkFixedPartitioner<T>
extends FlinkKafkaPartitioner<T> {
    private static final long serialVersionUID = -3785320239953858777L;
    private int parallelInstanceId;

    @Override
    public void open(int parallelInstanceId, int parallelInstances) {
        Preconditions.checkArgument((parallelInstanceId >= 0 ? 1 : 0) != 0, (Object)"Id of this subtask cannot be negative.");
        Preconditions.checkArgument((parallelInstances > 0 ? 1 : 0) != 0, (Object)"Number of subtasks must be larger than 0.");
        this.parallelInstanceId = parallelInstanceId;
    }

    @Override
    public int partition(T record, byte[] key, byte[] value, String targetTopic, int[] partitions) {
        Preconditions.checkArgument((partitions != null && partitions.length > 0 ? 1 : 0) != 0, (Object)"Partitions of the target topic is empty.");
        return partitions[this.parallelInstanceId % partitions.length];
    }

    public boolean equals(Object o) {
        return this == o || o instanceof FlinkFixedPartitioner;
    }

    public int hashCode() {
        return FlinkFixedPartitioner.class.hashCode();
    }
}

