/*
 * Decompiled with CFR 0.152.
 */
package shaded.alink.kafka.org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Map;
import shaded.alink.kafka.org.apache.kafka.common.protocol.ApiKeys;
import shaded.alink.kafka.org.apache.kafka.common.protocol.CommonFields;
import shaded.alink.kafka.org.apache.kafka.common.protocol.Errors;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Field;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Schema;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Struct;
import shaded.alink.kafka.org.apache.kafka.common.protocol.types.Type;
import shaded.alink.kafka.org.apache.kafka.common.requests.AbstractResponse;

public class SyncGroupResponse
extends AbstractResponse {
    private static final String MEMBER_ASSIGNMENT_KEY_NAME = "member_assignment";
    private static final Schema SYNC_GROUP_RESPONSE_V0 = new Schema(CommonFields.ERROR_CODE, new Field("member_assignment", Type.BYTES));
    private static final Schema SYNC_GROUP_RESPONSE_V1;
    private static final Schema SYNC_GROUP_RESPONSE_V2;
    private final Errors error;
    private final int throttleTimeMs;
    private final ByteBuffer memberState;

    public static Schema[] schemaVersions() {
        return new Schema[]{SYNC_GROUP_RESPONSE_V0, SYNC_GROUP_RESPONSE_V1, SYNC_GROUP_RESPONSE_V2};
    }

    public SyncGroupResponse(Errors error, ByteBuffer memberState) {
        this(0, error, memberState);
    }

    public SyncGroupResponse(int throttleTimeMs, Errors error, ByteBuffer memberState) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
        this.memberState = memberState;
    }

    public SyncGroupResponse(Struct struct) {
        this.throttleTimeMs = struct.getOrElse(CommonFields.THROTTLE_TIME_MS, 0);
        this.error = Errors.forCode(struct.get(CommonFields.ERROR_CODE));
        this.memberState = struct.getBytes(MEMBER_ASSIGNMENT_KEY_NAME);
    }

    @Override
    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    public Map<Errors, Integer> errorCounts() {
        return this.errorCounts(this.error);
    }

    public ByteBuffer memberAssignment() {
        return this.memberState;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.SYNC_GROUP.responseSchema(version));
        struct.setIfExists(CommonFields.THROTTLE_TIME_MS, (Object)this.throttleTimeMs);
        struct.set(CommonFields.ERROR_CODE, this.error.code());
        struct.set(MEMBER_ASSIGNMENT_KEY_NAME, (Object)this.memberState);
        return struct;
    }

    public static SyncGroupResponse parse(ByteBuffer buffer, short version) {
        return new SyncGroupResponse(ApiKeys.SYNC_GROUP.parseResponse(version, buffer));
    }

    @Override
    public boolean shouldClientThrottle(short version) {
        return version >= 2;
    }

    static {
        SYNC_GROUP_RESPONSE_V2 = SYNC_GROUP_RESPONSE_V1 = new Schema(CommonFields.THROTTLE_TIME_MS, CommonFields.ERROR_CODE, new Field(MEMBER_ASSIGNMENT_KEY_NAME, Type.BYTES));
    }
}

